package com.xdja.im.uikit.ui.view;

import android.annotation.TargetApi;
import android.graphics.drawable.Drawable;
import android.os.Build;
import androidx.annotation.ColorRes;
import androidx.annotation.NonNull;
import android.text.Html;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.google.gson.Gson;
import com.xdja.im.base.frame.view.AdapterBaseView;
import com.xdja.im.base.frame.view.AdapterSuperBaseView;
import com.xdja.im.common.imageloader.GlideCircleTransform;
import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.account.AccountBean;
import com.xdja.im.core.model.custom.CustomMsgInfo;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.TalkSessionBean;
import com.xdja.im.core.model.param.SessionParam;
import com.xdja.im.core.proxy.IMUiKitProxyImpl;
import com.xdja.im.lib.emoji.EmotionConfig;
import com.xdja.im.lib.emoji.utils.EmotionUtils;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.ui.CustomMessageData;
import com.xdja.im.uikit.ui.presenter.SessionListAdapterPresenter;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.im.uikit.utils.sys.TimeUtil;

/**
 * @Package:com.xdja.im.uikit.ui
 * @Author:Lei
 * @Creation:2017-04-13 00:37
 * @Version 1.0
 * @Description:
 */
public class ViewSessionItem extends AdapterSuperBaseView<SessionListAdapterPresenter, TalkSessionBean>
        implements AdapterBaseView<SessionListAdapterPresenter, TalkSessionBean> {

    private LinearLayout mLayout;
    /**
     * 头像
     */
    private ImageView mUserHeader;
    /**
     * 未读消息条数(开启免打扰模式时，为未读消息提示)
     */
    private TextView mUnReadCountTv;
    /**
     * 新消息标识
     */
    private ImageView mNewMsgFlagImg;
    /**
     * 用户名称
     */
    protected TextView mUserNameTv;
    /**
     * 消息内容
     */
    private TextView mContentTv;
    /**
     * 消息状态
     */
    private ImageView mMessageStateImg;
    /**
     * 会话展示时间
     */
    private TextView mDisplayTimeTv;
    /**
     * 免打扰标识
     */
    private ImageView mDisturbFlag;

    @Override
    protected void injectView() {
        super.injectView();
        mLayout = (LinearLayout) findViewById(R.id.layout_session_item);
        mUserHeader = (ImageView) findViewById(R.id.img_user_header);
        mUnReadCountTv = (TextView) findViewById(R.id.tv_unread_message);
        mNewMsgFlagImg = (ImageView) findViewById(R.id.img_new_message_flag);
        mUserNameTv = (TextView) findViewById(R.id.tv_user_name);
        mContentTv = (TextView) findViewById(R.id.tv_content);
        mMessageStateImg = (ImageView) findViewById(R.id.img_message_state);
        mDisplayTimeTv = (TextView) findViewById(R.id.tv_display_time);
        mDisturbFlag = (ImageView) findViewById(R.id.img_disturb_flag);
    }

    @Override
    public void bindDataSource(int position, @NonNull TalkSessionBean dataSource) {
        super.bindDataSource(position, dataSource);
       /* mUserHeader.setTag(dataSource.getTalkerAccount());
        mContentTv.setTag(dataSource.getTalkerAccount());*/
        if (dataSource == null) {
            LogUtil.e("dataSource is null.");
            return;
        }

        if (!dataSource.getTalkerAccount().equals(ConstDef.FILE_TRANSFER_ASS_ACCOUNT)) {
            updateUnreadCount();
        } else {
            updateFileAssistantUI();
        }
        updateSessionSenderInfo();
        updateSessionBaseInfo();
        updateMessageState();
        updateSessionParam();
    }

    @Override
    public void onViewReused() {
        super.onViewReused();
        int imgId = R.mipmap.im_uikit_user_header_40dp;
        if (dataSource.getTalkType() == ConstDef.CHAT_TYPE_P2G) {
            imgId = R.mipmap.im_uikit_group_avatar_40;
        }
        if (mUserHeader != null)
            mUserHeader.setImageResource(imgId);
        mUserNameTv.setText("");
        mContentTv.setText("");
        mDisplayTimeTv.setText("");
        mDisturbFlag.setVisibility(View.GONE);
        mUnReadCountTv.setVisibility(View.GONE);
        mNewMsgFlagImg.setVisibility(View.GONE);
    }

    private void updateSessionSenderInfo() {
        if (null != dataSource.getLastMsgAccount()) {
            updateSenderView(IMUiKitProxyImpl.getInstance().getAccount(dataSource.getLastMsgAccount(), ConstDef.CHAT_TYPE_P2P));
        } else {
            updateSenderView();
        }
    }

    private void updateSessionBaseInfo() {
        int imgId = R.mipmap.im_uikit_user_header_40dp;
        if (dataSource.getTalkType() == ConstDef.CHAT_TYPE_P2G) {
            imgId = R.mipmap.im_uikit_group_avatar_40;
        } else if (dataSource.getTalkType() == ConstDef.CHAT_TYPE_SYSTEM_INFO) {
            if (dataSource.getTalkerAccount().equals(ConstDef.FILE_TRANSFER_ASS_ACCOUNT)) {
                imgId = R.mipmap.im_uikit_file_transfer;
            } else
                imgId = R.mipmap.im_uikit_system_user_header_40dp;
        }
        mUserHeader.setImageResource(imgId);
        updateSessionBaseView(IMUiKitProxyImpl.getInstance().getAccount(dataSource.getTalkerAccount(), dataSource.getTalkType()));
    }

    private void updateSenderView() {
        mContentTv.setText(ellipsize(getContent("")));
        mDisplayTimeTv.setText(getDisplayTime());
    }

    private void updateSenderView(AccountBean accountBean) {
        if (null != accountBean) {
            mContentTv.setText(ellipsize(getContent(accountBean.getDisplayName())));
            mDisplayTimeTv.setText(getDisplayTime());
        }
    }

    private void updateSessionBaseView(AccountBean accountBean) {
        if (null == accountBean) return;

        if (!TextUtils.isEmpty(accountBean.getDisplayName())) {
            mUserNameTv.setText(accountBean.getDisplayName());
        } else {
            mUserNameTv.setText(accountBean.getAccount());
        }
        if (dataSource.getTalkType() == ConstDef.CHAT_TYPE_SYSTEM_INFO) {
            if (dataSource.getTalkerAccount().equals(ConstDef.FILE_TRANSFER_ASS_ACCOUNT)) {
                mUserHeader.setImageResource(R.mipmap.im_uikit_file_transfer);
                return;
            } else {
                mUserHeader.setImageResource(R.mipmap.im_uikit_system_user_header_40dp);
                return;
            }
        }

        Drawable avatarDrawable = accountBean.getAvatarDrawable();
        if (avatarDrawable != null) {
            mUserHeader.setImageDrawable(avatarDrawable);
            return;
        }

        int imgId = R.mipmap.im_uikit_user_header_40dp;
        if (dataSource.getTalkType() == ConstDef.CHAT_TYPE_P2G) {
            imgId = R.mipmap.im_uikit_group_avatar_40;
        }
        String avatarUrl = accountBean.getAvatarUrl();
        Glide.with(getActivity())
                .load(avatarUrl)
                .placeholder(imgId)
                .error(imgId)
                .bitmapTransform(new GlideCircleTransform(getContext()))
                .into(mUserHeader);
    }

    /**
     * 会话配置相关信息设置
     */
    private void updateSessionParam() {
        if (dataSource.getParam() != null) {
            //草稿
            /*if (!TextUtils.isEmpty(dataSource.getParam().getDraftContent()) &&
                    dataSource.getParam().getDraftTime() > 0) {
                setTextColor(R.color.base_red_80);
            } else {
                setTextColor(R.color.base_black_65);
            }*/

            //置顶
            if (dataSource.getParam().isTop()) {
                mLayout.setBackgroundResource(R.drawable.im_uikit_bg_session_item_top);
            } else {
                mLayout.setBackgroundResource(R.drawable.im_uikit_bg_session_item_normal);
            }

            //免打扰
            if (dataSource.getParam().isDisturb()) {
                if (mDisturbFlag != null)
                    mDisturbFlag.setVisibility(View.VISIBLE);
            } else {
                if (mDisturbFlag != null)
                    mDisturbFlag.setVisibility(View.GONE);
            }
        } else {
            if (mDisturbFlag != null)
                mDisturbFlag.setVisibility(View.GONE);
            mLayout.setBackgroundResource(R.drawable.im_uikit_bg_session_item_normal);
        }
    }

    /**
     * 加载用户信息
     */
   /* private void updateContentData(String displayName) {
        mContentTv.setText(ellipsize(getContent(displayName)));
        mDisplayTimeTv.setText(getDisplayTime());

        final String account = dataSource.getTalkerAccount();
        if (TextUtils.isEmpty(account)) {
            LogUtil.e("ERROR: User account is null.");
            return;
        }
        //防止用户名称加载错乱
        mUserNameTv.setTag(account);

        updateSessionBaseView(getPresenter().getAccount(account, dataSource.getTalkType()));

    }*/

    /**
     * 更新消息状态
     */
    private void updateMessageState() {
        mMessageStateImg.setVisibility(View.GONE);
        TalkMessageBean talkMessageBean = dataSource.getLastMsg();
        if (talkMessageBean == null) {
            LogUtil.w("session last message is null.");
            return;
        }

        //自定义消息
        if (talkMessageBean.getMessageType() == ConstDef.MSG_TYPE_CUSTOM
                || talkMessageBean.getMessageType() == ConstDef.MSG_TYPE_PRESENTATION) {
            return;
        }

        if (talkMessageBean.getFrom() == null || talkMessageBean.getTo() == null) {
            return;
        }

        //存在草稿，不更新状态
        SessionParam param = dataSource.getParam();
        if (param != null && !TextUtils.isEmpty(param.getDraftContent()) &&
                param.getDraftTime() > 0) {
            return;
        }

        //发送中
        if (talkMessageBean.getMessageState() == ConstDef.STATE_SENDING) {
            mMessageStateImg.setVisibility(View.VISIBLE);
            mMessageStateImg.setImageResource(R.mipmap.im_uikit_ic_message_state_sending);
        }

        //发送失败
        else if (talkMessageBean.getMessageState() == ConstDef.STATE_SEND_FAILED) {
            mMessageStateImg.setVisibility(View.VISIBLE);
            mMessageStateImg.setImageResource(R.mipmap.im_uikit_ic_message_state_fail);
        }
    }

    /**
     * 设置未读消息个数
     */
    private void updateUnreadCount() {

        int notReadCount = dataSource.getNotReadCount();
        if (notReadCount > 0) {
            setNotReadShow(true);

            SessionParam param = dataSource.getParam();
            if (param != null && param.isDisturb()) {
                mUnReadCountTv.setVisibility(View.GONE);
                mNewMsgFlagImg.setVisibility(View.VISIBLE);
                return;
            }
            if (notReadCount > 99) {
                setNotReadCount(Html.fromHtml("<b>...</b>"));
            } else {
                setNotReadCount(notReadCount + "");
            }
        } else {
            setNotReadShow(false);
        }
    }

    /**
     * 设置是否显示未读消息标识
     *
     * @param isShow {@code true} 显示未读标识 {@code false} 不显示未读标识
     */
    private void setNotReadShow(boolean isShow) {
        if (isShow) {
            mUnReadCountTv.setVisibility(View.VISIBLE);
        } else {
            mUnReadCountTv.setVisibility(View.GONE);
        }
        mNewMsgFlagImg.setVisibility(View.GONE);
    }

    /**
     * 设置未读消息显示
     *
     * @param countText 显示内容
     */
    private void setNotReadCount(CharSequence countText) {
        mUnReadCountTv.setText(countText);
    }

    /**
     * 设置文本显示颜色
     *
     * @param idRes
     */
    private void setTextColor(@ColorRes int idRes) {
        mContentTv.setTextColor(getColorRes(idRes));
    }

    /**
     * 用去用户名称
     *
     * @return
     */
    protected String getUserName() {
        return dataSource.getLastMsgAccount();
    }

    /**
     * 获取显示内容
     *
     * @return
     */
    protected CharSequence getContent(String displayName) {
        return "";
    }

    /**
     * 获取显示时间
     *
     * @return 时间字符串
     */
    protected String getDisplayTime() {
        // TODO: 2017/7/12 暂时显示最后一条消息时间，待产品给出定义
        if (dataSource.getLastTime() > 0) {
            return TimeUtil.convertSessionTime(dataSource.getLastTime());
        }
        return "";
    }

    public void setTimeVisibility(int visibility) {
        mDisplayTimeTv.setVisibility(visibility);
    }

    public CharSequence getCustomStr(TalkMessageBean talkMessageBean) {
        CustomMsgInfo customMsgInfo = new Gson().fromJson(talkMessageBean.getContent(), CustomMsgInfo.class);
        int type = customMsgInfo.getType();
        int state = customMsgInfo.getState();
        boolean isVideoCallback = (type == ConstDef.CALLBACK_P2P || type == ConstDef.CALLBACK_P2G || type == ConstDef.VIDEO_CHAT);
        long amountOfTime = customMsgInfo.getAmountOfTime();
        String content = "";
        boolean isMine = talkMessageBean.isMine();
        if (state == ConstDef.SENDER_CANCEL) {
            if (isMine) {
                content = "已取消";
            } else {
                if (isVideoCallback) {
                    if (type == ConstDef.VIDEO_CHAT) {
                        content = "未接视频通话";
                    } else {
                        content = "未接视频回传";
                    }

                } else {
                    if (type == ConstDef.MEETING_P2P) {
                        content = "未接语音通话";
                    } else {
                        content = "未接语音会议";
                    }
                }
            }
        } else if (state == ConstDef.NO_RESPONSE) {
            if (isMine) {
                content = "对方无应答";
            } else {
                if (isVideoCallback) {
                    if (type == ConstDef.VIDEO_CHAT) {
                        content = "未接视频通话";
                    } else {
                        content = "未接视频回传";
                    }
                } else {
                    if (type == ConstDef.MEETING_P2P) {
                        content = "未接语音通话";
                    } else {
                        content = "未接语音会议";
                    }
                }
            }
        } else if (state == ConstDef.RECER_CANCEL) {
            if (isMine) {
                content = "对方已拒绝";
            } else {
                content = "已拒绝";
            }
        } else if (state == ConstDef.OVER) {
            content = buildMsgContent(type, amountOfTime);
        } else if (state == ConstDef.DEAL_IN_OTHER_DEVICE) {
            content = "已在其它设备处理";
        } else if (state == ConstDef.CONNECTION_FAILED) {
            content = "连接失败";
        } else if (state == ConstDef.USER_IS_BUSY) {
            content = "对方忙";
        }
        return content;
    }

    private String buildMsgContent(int type, long amountOfTime) {
        StringBuilder builder = new StringBuilder();
        switch (type) {
            case ConstDef.CALLBACK_P2P:
            case ConstDef.CALLBACK_P2G:
                builder.append("视频回传");
                builder.append(" " + getFormatTime(amountOfTime));
                break;
            case ConstDef.MEETING_P2P:
                builder.append("语音通话");
                builder.append(" " + getFormatTime(amountOfTime));
                break;
            case ConstDef.MEETING_P2G:
                builder.append("语音会议");
                break;
            case ConstDef.VIDEO_CHAT:
                builder.append("视频通话");
                builder.append(" " + getFormatTime(amountOfTime));
                break;
        }

        return builder.toString();
    }

    /**
     * 草稿格式化
     *
     * @param content
     * @return
     */
    protected CharSequence formatDraft(String content) {
        String draftPreStr = "<font color=\"#941100\">" +
                getStringRes(R.string.im_uikit_draft) +
                "</font>";
        return Html.fromHtml(draftPreStr + content);
    }

    /**
     * 文本省略
     *
     * @param content
     * @return
     */
    @TargetApi(Build.VERSION_CODES.JELLY_BEAN)
    protected CharSequence ellipsize(CharSequence content) {
        return TextUtils.ellipsize(content, mContentTv.getPaint(),
                mContentTv.getMaxWidth() - 8, TextUtils.TruncateAt.END);
    }

    private String getFormatTime(long amountOfTime) {
        long hour = amountOfTime / 3600;
        long min = amountOfTime / 60 % 60;
        long second = amountOfTime % 60;
        String hourStr = "";
        String minStr = min < 10 ? "0" + min : "" + min;
        String secondStr = second < 10 ? "0" + second : "" + second;
        if (hour == 0) {
            hourStr = "";
            return minStr + ":" + secondStr;
        } else {
            hourStr = hour < 10 ? "0" + hour : "" + hour;
            return hourStr + ":" + minStr + ":" + secondStr;
        }
    }

    /**
     * 文件助手界面修改
     */
    private void updateFileAssistantUI() {
        mUnReadCountTv.setVisibility(View.GONE);
        mNewMsgFlagImg.setVisibility(View.GONE);
    }


    public CharSequence getCustomComponentTip(String content, boolean isGroup) {
        if (content.startsWith(ConstDef.IM_CUSTOM_MSG_TIP)) {
            String json = content.substring(ConstDef.IM_CUSTOM_MSG_TIP.length());
            String result = IMUiKitProxyImpl.getInstance().onCustomMsgSessionShowTip(dataSource.getLastMsg().isMine(), json);
            if (TextUtils.isEmpty(result) || result.startsWith(ConstDef.IM_CUSTOM_MSG_TIP)) {
                CustomMessageData customMessageData = new Gson().fromJson(json, CustomMessageData.class);
                return "[" + customMessageData.getType_name() + "] " + customMessageData.getTitle();
            } else
                return result;
        } else {
            if (isGroup) {
                return EmotionUtils.formatSpanContent(dataSource.getContent(),
                        getActivity(), EmotionConfig.FACE_ITEM_SMALL_VALUE);
            } else
                return EmotionUtils.formatSmallSpanContent(content,
                        getActivity());
        }
    }
}
