package com.xdja.im.uikit.ui.view;

import android.view.View;
import android.widget.AdapterView;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;

import com.xdja.im.base.frame.view.FragmentSuperBaseView;
import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.message.TalkSessionBean;
import com.xdja.im.lib.filemanage.util.NetworkUtils;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.constans.Constant;
import com.xdja.im.uikit.action.options.ImOption;
import com.xdja.im.uikit.ui.adapter.SessionListAdapter;
import com.xdja.im.uikit.ui.dialog.BaseRecyclerListDialog;
import com.xdja.im.uikit.ui.presenter.SessionListPresenter;
import com.xdja.im.uikit.ui.view.vu.SessionListVu;
import com.xdja.im.uikit.utils.FunctionUtils;
import com.xdja.im.uikit.utils.NetworkHelper;

import java.util.ArrayList;
import java.util.List;

/**
 * @Package: com.xdja.im.uikit.view
 * @Author: xdjaxa
 * @Date: 2017-04-10 20:23
 * @Version V1.0
 * @Comment:
 */
public class ViewSessionList extends FragmentSuperBaseView<SessionListPresenter>
        implements SessionListVu {

    /**
     * 会话列表
     */
    private ListView mChatSessionList;
    /**
     * 加载进度控件
     */
    private ProgressBar mLoadingPBar;
    /**
     * 消息列表为空显示view
     */
    private TextView mEmptyHintTv;
    /**
     * 长按Item弹出的控件
     */
//    private BaseListDialog mPopDialog;
    private BaseRecyclerListDialog mPopDialog;

    /**
     * 网络状态组件
     * @return
     */
    private LinearLayout networkStateLineaLayout;

    /**
     * 网络状态显示组件
     * @return
     */
    private TextView networkStateTv;
    /**
     * 弹框选项事件
     */
    protected List<ImOption> mImOptions = new ArrayList<>();

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_fragment_session_list;
    }

    @Override
    protected void injectView() {
        super.injectView();
        mChatSessionList = (ListView) findViewById(R.id.rv_session_list);
        mLoadingPBar = (ProgressBar) findViewById(R.id.pbar_loading);
        mEmptyHintTv = (TextView) findViewById(R.id.tv_empty);
        mChatSessionList.setEmptyView(mEmptyHintTv);
        networkStateLineaLayout = (LinearLayout) findViewById(R.id.network_state_view);
        networkStateTv = (TextView) findViewById(R.id.networkstate_tv);
        //根据静态注册的广播接收器中保存的当前网络状态是否可用的值，来确定View是否可见
        changeNetworkViewState(NetworkHelper.getHelper().getNetState());

        mPopDialog = new BaseRecyclerListDialog(getContext()) {
            @Override
            public List<ImOption> getOptions() {
                return buildImOptions();
            }
        };
        setListener();
    }

    private void setListener() {
        mChatSessionList.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                getPresenter().onListItemClick(position);
            }
        });
        mChatSessionList.setOnItemLongClickListener(new AdapterView.OnItemLongClickListener() {
            @Override
            public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id) {
                return showPopDialog(position);
            }
        });
        mPopDialog.setOnItemClickListener(new BaseRecyclerListDialog.onItemClickListener() {
            @Override
            public void onItemClick(View view, ImOption option, int itemPosition) {
                dismissPopDialog();
                switch (option.getOptionType()) {
                    case Constant.ITEM_SESSION_DELETE:      //会话删除
                        getPresenter().deleteSession(itemPosition);
                        break;
                    case Constant.ITEM_SESSION_SETTOP:      //会话置顶
                        if (NetworkUtils.checkNetworkState(getContext())) {
                            getPresenter().setSessionTop(itemPosition);
                        }
                        break;
                    case Constant.ITEM_SESSION_CANCELTOP:
                        if (NetworkUtils.checkNetworkState(getContext()))
                            getPresenter().deleteSessionTop(itemPosition);
                        break;

                    case Constant.ITEM_SESSION_SETDISTURB:  //会话免打扰
                        if (NetworkUtils.checkNetworkState(getContext()))
                            getPresenter().setDisturb(itemPosition);
                        break;
                    case Constant.ITEM_SESSION_CLOSEDISTURB:
                        if (NetworkUtils.checkNetworkState(getContext()))
                            getPresenter().deleteDisturb(itemPosition);
                        break;
                }
            }
        });
    }

    @Override
    public void setAdapter(SessionListAdapter adapter) {
        mChatSessionList.setAdapter(adapter);
        mEmptyHintTv.setVisibility(View.GONE);
    }

    @Override
    public void setProgressBarVisibility(int visibility) {
        mLoadingPBar.setVisibility(visibility);
    }

    private List<ImOption> buildImOptions() {
        mImOptions.add(new ImOption(Constant.ITEM_SESSION_DELETE, getStringRes(R.string.im_uikit_session_option_delete)));
        mImOptions.add(new ImOption(Constant.ITEM_SESSION_SETTOP, getStringRes(R.string.im_uikit_session_option_settop)));
        mImOptions.add(new ImOption(Constant.ITEM_SESSION_CANCELTOP, getStringRes(R.string.im_uikit_session_option_canceltop)));
        mImOptions.add(new ImOption(Constant.ITEM_SESSION_SETDISTURB, getStringRes(R.string.im_uikit_session_option_opendisturb)));
        mImOptions.add(new ImOption(Constant.ITEM_SESSION_CLOSEDISTURB, getStringRes(R.string.im_uikit_session_option_closedisturb)));
        return mImOptions;
    }

    /**
     * 显示选择框
     */
    private boolean showPopDialog(int position) {
        List<ImOption> data = new ArrayList<>();
        TalkSessionBean talkSessionBean = getPresenter().isSessionTalk(position);
        if (talkSessionBean == null) return false;
        data.add(mImOptions.get(0));
        if (talkSessionBean.getParam() == null || !talkSessionBean.getParam().isTop()) {
            data.add(mImOptions.get(1));
        } else {
            data.add(mImOptions.get(2));
        }

        //文件助手不需要消息免打扰功能，去掉
        if (!talkSessionBean.getTalkerAccount().equals(ConstDef.FILE_TRANSFER_ASS_ACCOUNT)) {
            // TODO: 2017/9/12 需求：要求不显示免打扰
            if (talkSessionBean.getParam() == null || !talkSessionBean.getParam().isDisturb()) {
                data.add(mImOptions.get(3));
            } else {
                data.add(mImOptions.get(4));
            }
        }
        mPopDialog.addData(data);
        mPopDialog.show(position);
        return true;
    }

    /**
     * 隐藏选择框
     */
    protected void dismissPopDialog() {
        if (mPopDialog != null) {
            mPopDialog.dismiss();
        }
    }

    @Override
    public void changeViewSate(int state) {
        changeNetworkViewState(state);
        if(!NetworkHelper.getHelper().isFirstNotice()
                && FunctionUtils.isAppOnForeground(getActivity())){
            if(state == NetworkHelper.NET_DISABLED){
                Toast.makeText(getActivity(), "Network unavailable" , Toast.LENGTH_LONG).show();
            }else if(state == NetworkHelper.NO_SERVER){
                Toast.makeText(getActivity(), "Unable to access the server" , Toast.LENGTH_LONG).show();
            }
        }
    }

    /**
     * 网络状态监测
     */
    private void changeNetworkViewState(int flag){
        String tips;
        switch (flag){
            case NetworkHelper.NET_DISABLED:
                tips = getActivity().getResources().getString(R.string.im_uikit_network_disabled);
                networkStateTv.setText(tips);
                networkStateLineaLayout.setVisibility(View.VISIBLE);
                break;
            case  NetworkHelper.NO_SERVER:
                tips = getActivity().getResources().getString(R.string.im_uikit_network_no_server);
                networkStateTv.setText(tips);
                networkStateLineaLayout.setVisibility(View.VISIBLE);
                break;
            case NetworkHelper.NET_OK:
                networkStateLineaLayout.setVisibility(View.GONE);
                break;
            default:
                break;
        }
    }
}
