package com.xdja.im.uikit.ui.view;

import androidx.annotation.NonNull;
import android.text.TextUtils;

import com.google.gson.Gson;
import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.TalkSessionBean;
import com.xdja.im.core.model.param.SessionParam;
import com.xdja.im.lib.emoji.utils.EmotionUtils;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.ui.CustomItemDataProvider;
import com.xdja.im.uikit.utils.log.LogUtil;

/**
 * @Package: com.xdja.im.uikit.ui
 * @Author: xdjaxa
 * @Creation: 2017-04-18 14:16
 * @Version V1.0
 * @Description:系统消息类型
 */
public class ViewSystemSessionItem extends ViewSessionItem {

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_item_session_system;
    }

    @Override
    public void bindDataSource(int position, @NonNull TalkSessionBean dataSource) {
        super.bindDataSource(position, dataSource);
        mUserNameTv.setText(getStringRes(R.string.im_uikit_assistant_name));
    }

    @Override
    protected CharSequence getContent(String displayName) {
        //草稿处理
        SessionParam param = dataSource.getParam();
        if (param != null && !TextUtils.isEmpty(param.getDraftContent()) &&
                param.getDraftTime() > 0) {
            CharSequence content = formatDraft(param.getDraftContent());
            LogUtil.d("ViewSingleItem draft:" + content);
            return EmotionUtils.formatSmallSpanContent(content,
                    getActivity());
        }

        TalkMessageBean talkMessageBean = dataSource.getLastMsg();
        if (talkMessageBean == null) {
            LogUtil.w("Last message info is null.");
            return "";
        }
        int messageType = talkMessageBean.getMessageType();

        //闪信并且已销毁
        if (!talkMessageBean.isMine() &&
                talkMessageBean.isBomb() &&
                (talkMessageBean.getMessageState() == ConstDef.STATE_DESTROY)) {
            return getStringRes(R.string.im_uikit_bomb);
        }
        //普通消息
        switch (messageType) {
            case ConstDef.MSG_TYPE_TEXT:
                String content = talkMessageBean.getContent();
                return getCustomComponentTip(content, false);
            case ConstDef.MSG_TYPE_VOICE:
                return getStringRes(R.string.im_uikit_voice);
            case ConstDef.MSG_TYPE_VIDEO:
                return getStringRes(R.string.im_uikit_video);
            case ConstDef.MSG_TYPE_PHOTO:
                return getStringRes(R.string.im_uikit_image);
            case ConstDef.MSG_TYPE_FILE:
                return getStringRes(R.string.im_uikit_file);
            case ConstDef.MSG_TYPE_WEB:
                return getStringRes(R.string.im_uikit_web_message);
            case ConstDef.MSG_TYPE_CUSTOM:
                return getCustomStr(talkMessageBean);
            case ConstDef.MSG_TYPE_ASSISTANT:
                return getSystemStr(dataSource.getContent());
            default:
                return dataSource.getContent() == null ? "" : dataSource.getContent();
        }
    }

    private String getSystemStr(CharSequence json) {
        CustomItemDataProvider customItemDataProvider = new Gson().fromJson(json.toString(), CustomItemDataProvider.class);
        String str = "";
        if (customItemDataProvider != null) {
            str = "[" + customItemDataProvider.getType_name() + "] " + customItemDataProvider.getTitle();
        }
        return str;
    }

}



