package com.xdja.im.uikit.ui.view.vu;

import com.xdja.im.base.frame.view.ActivityBaseView;
import com.xdja.im.uikit.ui.adapter.FilePreviewAdapter;
import com.xdja.im.uikit.ui.presenter.FilePreviewPresenter;

import androidx.viewpager.widget.ViewPager;

/**
 * @Package: com.xdja.im.uikit.ui.view.vu
 * @Author: xdjaxa
 * @Creation: 2017-05-15 10:19
 * @Version V1.0
 * @Description:
 */
public interface FilePreviewVu extends ActivityBaseView<FilePreviewPresenter> {

    /**
     * 设置适配器
     *
     * @param adapter 适配器
     */
    void setAdapter(FilePreviewAdapter adapter);

    /**
     * 设置当前页面显示位置
     *
     * @param position
     */
    void setCurrentPosition(int position);

    /**
     * 获取ViewPager
     *
     * @return
     */
    ViewPager getViewPager();

    /**
     * 加载进度是否可见
     *
     * @param visibility
     */
    void setProgressVisibility(int visibility);

    /**
     * 显示空布局
     */
    void showEmptyView();

    /**
     * 文件下载完成回调接口
     *
     * @param position 当前下载完成文件所在的位置
     */
    void fileDownloadFinish(int position);
}
