package com.xdja.im.uikit.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.ImageView;

import com.bumptech.glide.DrawableRequestBuilder;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestManager;
import com.xdja.im.common.imageloader.GlideCircleTransform;
import com.xdja.im.uikit.R;

import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.appcompat.widget.AppCompatImageView;

/**
 * @Package: com.xdja.im.uikit.view
 * @Author: xdjaxa
 * @Creation: 2017-04-18 14:54
 * @Version V1.0
 * @Description: 圆形图像
 */
public class CircleImageView extends AppCompatImageView {

    @DrawableRes
    private int mDefaultImage = R.mipmap.im_uikit_user_header_40dp;

    public CircleImageView(Context context) {
        super(context);
    }

    public CircleImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CircleImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public <T> void loadImage(@NonNull T drawable, boolean isNeedFit, int defaultImage) {
        mDefaultImage = defaultImage;
        loadImage(drawable, isNeedFit);
    }

    public <T> void loadImage(@NonNull T drawable, boolean isNeedFit) {
        loadImage(drawable, isNeedFit, true, this, true);
    }

    public <T> void loadImage(@NonNull T drawable, boolean isNeedFit, boolean showDefaultImage) {
        loadImage(drawable, isNeedFit, true, this, showDefaultImage);
    }

    private <T> void loadImage(final @NonNull T drawable, boolean isNeedFit, boolean isCircle,
                               ImageView imageView, boolean showDefaultImage) {

        RequestManager requestManager = Glide.with(getContext().getApplicationContext());
        DrawableRequestBuilder builder;
        if (drawable == null || "".equals(drawable)) {
            builder = requestManager.load(mDefaultImage);
        } else {
            /*T drawable2 = drawable;
            if (drawable instanceof String) {
                String url = (String) drawable;
                drawable2 = (T) url;
                /*if (url.length() > 8 && url.startsWith("http") && !url.contains("download")) {
                    int pos = url.indexOf("/", 8);
                    if (pos > 0 && pos < url.length()) {
                        url = url.substring(0, pos) + "/download" + url.substring(pos, url.length());
                        drawable2 = (T) url;
                    }
                }
            }*/
            builder = requestManager.load((String)drawable);
        }
        if (isNeedFit) {
            builder = builder.fitCenter();
        }
        builder.crossFade();
        //显示错误图片和占位符
        if (showDefaultImage) builder.placeholder(mDefaultImage);
        builder.error(mDefaultImage);
        if (isCircle) {
            builder.transform(new GlideCircleTransform(getContext()));
        }
        builder.into(imageView);
    }

    @Override
    public void setImageBitmap(final Bitmap bm) {
        //防止view没有渲染测不到宽高
        post(new Runnable() {
            @Override
            public void run() {
                //CircleImageView.super.setImageBitmap(new GlideCircleTransform(getContext())
                //        .transform(null, bm, getWidth(), getHeight()));
            }
        });
    }


    @Override
    public void setBackground(Drawable background) {
        //super.setBackground(new BitmapDrawable(new GlideCircleTransform(getContext())
        //        .transform(null, ((BitmapDrawable) background).getBitmap(), getWidth(), getHeight())));
    }
}
