package com.xdja.im.uikit.view;

import android.annotation.SuppressLint;
import android.content.Context;
import androidx.annotation.Nullable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.ViewTreeObserver;
import android.widget.TextView;

/**
 * Created by wenqi on 2018/3/15.
 *
 */

@SuppressLint("AppCompatCustomView")
public class ElliTextView extends TextView {

    private CharSequence text;


    public ElliTextView(Context context) {
        super(context);
        init();
    }

    public ElliTextView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        init();
    }

    private void init() {
        this.getViewTreeObserver().addOnGlobalLayoutListener(new OnGlobalLayoutListenerByEllipSize(this,1));
    }


    public void setStrText(CharSequence text){
        this.text = text;
        super.setText(text);
    }

    public CharSequence getStrText(){
        return text;
    }



    class OnGlobalLayoutListenerByEllipSize implements ViewTreeObserver.OnGlobalLayoutListener {

        private ElliTextView mTextView;
        private int mMaxLines;  //最大行数

        public OnGlobalLayoutListenerByEllipSize(ElliTextView textView, int maxLines) {
            if (maxLines <= 0)
                throw new IllegalArgumentException("maxLines不能小于等于0");
            this.mTextView = textView;
            this.mMaxLines = maxLines;
            this.mTextView.setMaxLines(mMaxLines + 1);
            this.mTextView.setSingleLine(false);
        }

        @Override
        public void onGlobalLayout() {
            if (mTextView.getLineCount() > mMaxLines) {
                int line = mTextView.getLayout().getLineEnd(mMaxLines - 1);
                CharSequence truncate = "...";//定义成CharSequence类型，是为了兼容emoji表情，如果使用String类型则会造成emoji无法显示
                CharSequence text = mTextView.getStrText();
                int length = 0;

                try {
                    length = text.length();
                    text = text.subSequence(0, line - 3);
                } catch (Exception e) {
                    truncate = "";
                    text = mTextView.getText();
                }
                TextUtils.TruncateAt at = mTextView.getEllipsize();
                if (at == TextUtils.TruncateAt.START) {
                    mTextView.setText(truncate);
                    mTextView.append(text);
                } else if (at == TextUtils.TruncateAt.MIDDLE) {
                    mTextView.setText(text.subSequence(0, text.length() / 2));
                    mTextView.append(truncate);
                    mTextView.append(text.subSequence(text.length() / 2, text.length()));
                    int newLength = mTextView.getText().length();
                    if (newLength < length) {
                        newLength = newLength - 3;
                        mTextView.setText(mTextView.getStrText().subSequence(0, newLength / 2));
                        mTextView.append(truncate);
                        mTextView.append(mTextView.getStrText().subSequence(mTextView.getStrText().length() - newLength / 2, mTextView.getStrText().length()));
                    }
                } else {
                    mTextView.setText(text);
                    mTextView.append(truncate);
                }
            }
        }
    }

}
