/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs;

import com.xdja.svs.config.ConfigItem;
import com.xdja.svs.param.SignAlgEnum;
import java.net.Socket;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.x500.X500Name;
import protocol.response.GMT0029_RelateAppContext;

public class Session {
    private ConfigItem configItem;
    private Socket socketFd;
    private GMT0029_RelateAppContext appContext;
    private int privateKeyIndex;
    private int keyValueLen;
    private SignAlgEnum signAlg;
    private long encAlg;
    private String signID;
    private X500Name signIssuer;
    private ASN1Integer signSerial;
    private X500Name encIssuer;
    private ASN1Integer encSerial;
    private X509Certificate signCert;
    private X509Certificate encCert;

    public Session(ConfigItem configItem) {
        this.configItem = configItem;
    }

    public void setSocketFd(Socket socketFd) {
        this.socketFd = socketFd;
    }

    public Socket getSocketFd() {
        return this.socketFd;
    }

    public String getServerIP() {
        return this.configItem.getServerIp();
    }

    public int getServerPort() {
        return this.configItem.getServerPort();
    }

    public int getTimeOut() {
        return this.configItem.getTimeOut();
    }

    public int getPrivateKeyIndex() {
        return this.appContext.getKeyIndex().getValue().intValue();
    }

    public String getPrivateKeyPwd() {
        return this.configItem.getPassWd();
    }

    public int getVerifyLevel() {
        return this.configItem.getVerifyLevel();
    }

    public boolean isOcsp() {
        return this.configItem.isOcspStatus();
    }

    public int getXMLType() {
        return this.configItem.getXmlType();
    }

    public boolean isCertReq() {
        return this.configItem.getUiReqType() == 0;
    }

    public String getAppName() {
        return this.configItem.getAppName();
    }

    public int getPrivateKeyPwdLength() {
        return this.getPrivateKeyPwd().length();
    }

    public void setSignAlg(SignAlgEnum signAlg) {
        this.signAlg = signAlg;
    }

    public long getSignAlg() {
        return this.signAlg.getValue();
    }

    public long getEncAlg() {
        return this.encAlg;
    }

    public String getSignID() {
        return this.signID;
    }

    public X500Name getSignIssuer() {
        return this.appContext.getSignIssuer();
    }

    public ASN1Integer getSignSerial() {
        return this.appContext.getSignSerial();
    }

    public X500Name getEncIssuer() {
        return this.appContext.getEncIssuer();
    }

    public ASN1Integer getEncSerial() {
        return this.appContext.getEncSerial();
    }

    public X509Certificate getSignCert() {
        return this.appContext.getSignCert();
    }

    public X509Certificate getEncCert() {
        return this.appContext.getEncCert();
    }

    public void setAppContext(GMT0029_RelateAppContext relateAppContext) {
        this.appContext = relateAppContext;
    }
}

