/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs;

import com.xdja.svs.SvsSofInstance;
import common.ApiMethodId;
import common.ReadJsonConfig;
import execption.PointerException;
import execption.SOR_AppNotfoundException;
import execption.SOR_InitException;
import execption.SOR_ParameterNotSupportException;
import execption.SOR_ReadFileException;
import execption.SOR_WriteFileException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.net.Socket;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.util.encoders.Base64;
import protocol.SvsRequest;
import protocol.SvsResponse;
import protocol.request.GetInstanceReq;
import protocol.response.GMT0029_RelateAppContext;
import protocol.response.GetInstanceResp;
import socket.SocketFactory;

public class SvsApi {
    public boolean SOF_setCertTrustList(String ctlAltName, String ctlContent) throws Exception {
        if ("".equals(ctlAltName) || ctlAltName == null || ctlAltName.length() == 0) {
            throw new PointerException("SOF_setCertTrustList : the ctlAltName input is null");
        }
        if (ctlAltName.length() > 64) {
            throw new SOR_ParameterNotSupportException("SOF_setCertTrustList : the ctlAltName length is too long, only support length less then 64!");
        }
        if ("".equals(ctlContent) || ctlContent == null || ctlContent.length() == 0) {
            throw new PointerException("SOF_setCertTrustList : the ctlContent input is null");
        }
        try {
            Base64.decode((String)ctlContent);
        }
        catch (Exception e) {
            throw new SOR_ParameterNotSupportException("SOF_setCertTrustList : the ctlContent is not Base64 format!");
        }
        String ctl_dir = null;
        try {
            ctl_dir = ReadJsonConfig.readctlPath();
        }
        catch (Exception e) {
            throw new SOR_ReadFileException("SOF_setCertTrustList : ctl_path is not exist!");
        }
        File file = new File(ctl_dir + ctlAltName);
        if (file.exists()) {
            throw new SOR_ReadFileException("SOF_setCertTrustList : ctlAltName is exist!");
        }
        try {
            file.createNewFile();
            FileWriter fileWritter = new FileWriter(file.getAbsoluteFile(), true);
            fileWritter.write(ctlContent);
            fileWritter.close();
        }
        catch (Exception e) {
            throw new SOR_WriteFileException("SOF_setCertTrustList : Create Ctl file is error!");
        }
        return true;
    }

    public String SOF_getCertTrustListAltNames() throws Exception {
        String ctl_dir = null;
        try {
            ctl_dir = ReadJsonConfig.readctlPath();
        }
        catch (Exception e) {
            throw new SOR_ReadFileException("SOF_getCertTrustListAltNames : ctl_path is not exist!");
        }
        File dir = new File(ctl_dir);
        if (!dir.exists() || !dir.isDirectory()) {
            throw new SOR_ReadFileException("SOF_getCertTrustListAltNames : CertTrustListAltName is not exist!");
        }
        String fileNames = null;
        String[] files = dir.list();
        for (int i = 0; i < files.length; ++i) {
            File file = new File(dir, files[i]);
            if (!file.isFile()) continue;
            fileNames = i == 0 ? files[i] : fileNames + "@" + files[i];
        }
        return fileNames;
    }

    public String SOF_getCertTrustList(String ctlAltName) throws Exception {
        if ("".equals(ctlAltName) || ctlAltName == null) {
            throw new PointerException("SOF_getCertTrustList : the ctlAltName input is null");
        }
        if (ctlAltName.length() > 64) {
            throw new SOR_ParameterNotSupportException("SOF_getCertTrustList : the ctlAltName length is too long, only support length less then 64!");
        }
        String ctl_dir = null;
        try {
            ctl_dir = ReadJsonConfig.readctlPath();
        }
        catch (Exception e) {
            throw new SOR_ReadFileException("SOF_getCertTrustList : ctl_path is not exist!");
        }
        File file = new File(ctl_dir + ctlAltName);
        if (!file.exists()) {
            throw new SOR_ReadFileException("SOF_getCertTrustList : ctlAltName is not exist!");
        }
        StringBuilder sb = new StringBuilder();
        String s = "";
        BufferedReader br = new BufferedReader(new FileReader(file));
        while ((s = br.readLine()) != null) {
            sb.append(s + "\n");
        }
        br.close();
        return sb.toString();
    }

    public boolean SOF_delCertTrustList(String ctlAltName) throws Exception {
        if ("".equals(ctlAltName) || ctlAltName == null) {
            throw new PointerException("SOF_delCertTrustList : the ctlAltName input is null");
        }
        if (ctlAltName.length() > 64) {
            throw new SOR_ParameterNotSupportException("SOF_delCertTrustList : the ctlAltName length is too long, only support length less then 64!");
        }
        String ctl_dir = null;
        try {
            ctl_dir = ReadJsonConfig.readctlPath();
        }
        catch (Exception e) {
            throw new SOR_ReadFileException("SOF_delCertTrustList : ctl_path is not exist!");
        }
        File file = new File(ctl_dir + ctlAltName);
        if (!file.exists()) {
            throw new SOR_ReadFileException("SOF_delCertTrustList : ctlAltName is not exist!");
        }
        try {
            file.delete();
        }
        catch (Exception e) {
            throw new SOR_ReadFileException("SOF_delCertTrustList : ctlAltName delet is error!");
        }
        return true;
    }

    public static SvsSofInstance SOF_getInstance(String PolicyName) throws Exception {
        int xmlType;
        boolean ocspStatus;
        int verifyLevel;
        String passWd;
        int timeOut;
        int serverPort;
        String serverHost;
        String appName;
        if ("".equals(PolicyName) || PolicyName == null) {
            throw new PointerException("SOF_getInstance : the PolicyName input is null");
        }
        if (PolicyName.length() <= 0 || PolicyName.length() > 60) {
            throw new SOR_ParameterNotSupportException("SOF_getInstance : the PolicyName length is error");
        }
        try {
            appName = ReadJsonConfig.ReadJsonConfig(PolicyName).get((Object)"appName").toString();
        }
        catch (Exception e) {
            appName = null;
        }
        try {
            serverHost = ReadJsonConfig.ReadJsonConfig(PolicyName).get((Object)"serverIp").toString();
            serverPort = Integer.parseInt(ReadJsonConfig.ReadJsonConfig(PolicyName).get((Object)"serverPort").toString());
            timeOut = Integer.parseInt(ReadJsonConfig.ReadJsonConfig(PolicyName).get((Object)"timeOut").toString());
            passWd = ReadJsonConfig.ReadJsonConfig(PolicyName).get((Object)"passWd").toString();
            verifyLevel = Integer.parseInt(ReadJsonConfig.ReadJsonConfig(PolicyName).get((Object)"verifyLevel").toString());
            ocspStatus = Boolean.parseBoolean(ReadJsonConfig.ReadJsonConfig(PolicyName).get((Object)"ocspStatus").toString());
            xmlType = Integer.parseInt(ReadJsonConfig.ReadJsonConfig(PolicyName).get((Object)"xmlType").toString());
        }
        catch (Exception e) {
            throw new SOR_InitException("SOF_getInstance : Failed to get value from com.xdja.svs.config file");
        }
        Socket socket = SocketFactory.getSocketConnection(serverHost, serverPort, timeOut);
        if (socket == null) {
            throw new SOR_InitException("SOF_getInstance : Failed to network connection!");
        }
        SvsSofInstance svsSofInstance = new SvsSofInstance();
        svsSofInstance.sof.setxSession(socket);
        if (appName != null && !"".equals(appName)) {
            GetInstanceReq getInstanceReq = new GetInstanceReq(appName);
            SvsRequest svsRequest = new SvsRequest(ApiMethodId.RELATE_APP_REQ.value(), getInstanceReq);
            ASN1Sequence sequence = SocketFactory.sendAndreceiveBody(svsSofInstance.sof, "SOF_getInstance", svsRequest.getEncoded());
            if (sequence == null) {
                throw new SOR_InitException("SOF_getInstance : Failed to send data!");
            }
            SvsResponse svsResponse = new SvsResponse(sequence);
            if (svsResponse.getVersion().getValue().intValue() != 0) {
                throw new SOR_InitException("SOF_getInstance : Response Version is error, only equal 0");
            }
            GetInstanceResp getInstanceResp = new GetInstanceResp(sequence.getObjectAt(2));
            if (getInstanceResp.getRespValue().getValue().intValue() != 0) {
                throw new SOR_AppNotfoundException("SOF_getInstance : App not found!");
            }
            GMT0029_RelateAppContext appContext = getInstanceResp.getAppContext();
            svsSofInstance.sof.setAppName(appName);
            svsSofInstance.sof.setKeyIndex(appContext.getKeyIndex().getValue().intValue());
            svsSofInstance.sof.setSignCert(appContext.getSignCert());
            svsSofInstance.sof.setSignIssuer(appContext.getSignIssuer());
            svsSofInstance.sof.setSignSerial(appContext.getSignSerial());
            svsSofInstance.sof.setEncCert(appContext.getEncCert());
            svsSofInstance.sof.setEncIssuer(appContext.getEncIssuer());
            svsSofInstance.sof.setEncSerial(appContext.getEncSerial());
        }
        svsSofInstance.sof.setxSession(socket);
        svsSofInstance.sof.setServerIP(serverHost);
        svsSofInstance.sof.setServerPort(serverPort);
        svsSofInstance.sof.setTimeOut(timeOut);
        svsSofInstance.sof.setKeyValue(passWd);
        svsSofInstance.sof.setVerifylevel(verifyLevel);
        svsSofInstance.sof.setOcsp(ocspStatus);
        svsSofInstance.sof.setXMLType(xmlType);
        svsSofInstance.sof.setSignID("1234567812345678");
        return svsSofInstance;
    }
}

