/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs;

import cn.hutool.core.util.XmlUtil;
import com.xdja.svs.encryptdata.EncryptDataApi;
import com.xdja.svs.encryptdata.EncryptDataDto;
import com.xdja.svs.hash.HashApi;
import com.xdja.svs.timestamp.TimeStampApi;
import common.ApiMethodId;
import common.ConvertPublicKeyFrombyte;
import common.DateObject;
import common.ReadJsonConfig;
import common.SofInstance;
import common.SvsOidEnum;
import encapsulation.GMT0010_SignedData;
import encapsulation.GMT0010_SignerInfo;
import execption.SOR_ParameterNotSupportException;
import execption.errorCode;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import protocol.SvsRequest;
import protocol.hash.response.HashFinalResp;
import protocol.random.GenRandomReq;
import protocol.random.GenRandomResp;
import protocol.request.ParseCertReq;
import protocol.request.ValidateCertReq;
import protocol.request.VerifySignedMessageReq;
import protocol.response.CreateTimeStampRespResp;
import protocol.response.ParseCertResp;
import protocol.response.ValidateCertResp;
import protocol.response.VerifySignedMessageResp;
import protocol.timestamp.CreateTimeStampReq;
import socket.SocketFactory;
import socket.TLV;
import socket.TLVTools;
import sun.security.pkcs11.wrapper.Functions;
import utils.Asn1Util;
import utils.Base64Utils;
import utils.EncryptDecryptUtils;
import utils.SignedVerifyUtils;
import utils.XMLSignedVerifyUtils;

public class SvsSofInstance {
    public SofInstance sof = new SofInstance();
    private SignedVerifyUtils signedVerifyUtils = new SignedVerifyUtils();

    private boolean Checkforinitialize(String funcName) {
        if (this.sof.getxSession() == null || "".equals(this.sof.getxSession())) {
            this.sof.setErrCode(errorCode.SOR_NotInitializeErr);
            return false;
        }
        if (this.sof.getKeyValue() == null || "".equals(this.sof.getKeyValue())) {
            this.sof.setErrCode(errorCode.SOR_NotInitializeErr);
            return false;
        }
        return true;
    }

    private boolean judgeInputisNull(String str) {
        if (str == null) {
            return false;
        }
        if ("".equals(str)) {
            return false;
        }
        return str.length() != 0;
    }

    private boolean judgeInputisNull(byte[] str) {
        if (str == null) {
            return false;
        }
        if ("".equals(str)) {
            return false;
        }
        return str.length != 0;
    }

    private boolean judgeInputisNull(X509Certificate str) {
        if (str == null) {
            return false;
        }
        return !"".equals(str);
    }

    private boolean judgeInputLength(int len, int mix, int max) {
        if (len < mix) {
            return false;
        }
        return len <= max;
    }

    private boolean judgeSignMethod(long signMethod) {
        if (signMethod == SvsOidEnum.SM3_RSA) {
            return true;
        }
        if (signMethod == SvsOidEnum.SHA1_RSA) {
            return true;
        }
        if (signMethod == SvsOidEnum.SHA256_RSA) {
            return true;
        }
        return signMethod == SvsOidEnum.SM3_SM2;
    }

    private boolean judgeEncMethod(long encMethod) {
        if (encMethod == SvsOidEnum.SGD_SM1_ECB) {
            return true;
        }
        if (encMethod == SvsOidEnum.SGD_SM4_ECB) {
            return true;
        }
        return encMethod == SvsOidEnum.SGD_AES_ECB;
    }

    private boolean judgeVerifylevel(int level) {
        if (level == 0) {
            return true;
        }
        if (level == 1) {
            return true;
        }
        if (level == 2) {
            return true;
        }
        return level == -1;
    }

    private boolean judgeTypelevel(int level) {
        if (level == 1) {
            return true;
        }
        if (level == 2) {
            return true;
        }
        return level == 3;
    }

    private boolean judgeisBase64(String base64str) {
        String base64Pattern = "^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$";
        return Pattern.matches(base64Pattern, base64str);
    }

    public void SOF_setSignMethod(long signMethod) throws Exception {
        if (signMethod != SvsOidEnum.SM3_RSA && signMethod != SvsOidEnum.SHA1_RSA && signMethod != SvsOidEnum.SHA256_RSA && signMethod != SvsOidEnum.SM3_SM2) {
            this.sof.setErrCode(errorCode.SOR_AlgoTypeErr);
            throw new SOR_ParameterNotSupportException("signMethod is error, only support SM3_RSA(65537)\u3001SM3_SHA1(65538)\u3001SM3_SHA256(65540)\u3001SM3_SM2(131585)");
        }
        this.sof.setSignMethod(signMethod);
    }

    public long SOF_getSignMethod() {
        long signMethod = this.sof.getSignMethod();
        if (signMethod != SvsOidEnum.SM3_RSA && signMethod != SvsOidEnum.SHA1_RSA && signMethod != SvsOidEnum.SHA256_RSA && signMethod != SvsOidEnum.SM3_SM2) {
            this.sof.setErrCode(errorCode.SOR_AlgoTypeErr);
            return 0L;
        }
        return signMethod;
    }

    public void SOF_setEncryptMethod(long encryptMethod) throws Exception {
        if (encryptMethod != SvsOidEnum.SGD_SM1_ECB && encryptMethod != SvsOidEnum.SGD_SM4_ECB && encryptMethod != SvsOidEnum.SGD_AES_ECB) {
            this.sof.setErrCode(errorCode.SOR_AlgoTypeErr);
            throw new SOR_ParameterNotSupportException("encMethod is error");
        }
        this.sof.setEncMethod(encryptMethod);
    }

    public long SOF_getEncryptMethod() {
        long encryptMethod = this.sof.getEncMethod();
        if (encryptMethod != SvsOidEnum.SGD_SM1_ECB && encryptMethod != SvsOidEnum.SGD_SM4_ECB && encryptMethod != SvsOidEnum.SGD_AES_ECB) {
            this.sof.setErrCode(errorCode.SOR_AlgoTypeErr);
            return 0L;
        }
        return this.sof.getEncMethod();
    }

    public String SOF_getServerCertificate() {
        if (!this.judgeInputisNull(this.sof.getAppName())) {
            this.sof.setErrCode(errorCode.SOR_APPNOTFOUND);
            return null;
        }
        try {
            byte[] cert = this.sof.getSignCert().getEncoded();
            if (!this.judgeInputisNull(cert)) {
                this.sof.setErrCode(errorCode.SOR_CertNotFountErr);
                return null;
            }
            return Base64Utils.encode(cert);
        }
        catch (Exception e) {
            this.sof.setErrCode(errorCode.SOR_ObjErr);
            return null;
        }
    }

    public String SOF_getServerCertificateByUsage(short certUsage) {
        if (!this.judgeInputisNull(this.sof.getAppName())) {
            this.sof.setErrCode(errorCode.SOR_APPNOTFOUND);
            return null;
        }
        if (certUsage == 1) {
            if (!this.judgeInputisNull(this.sof.getEncCert())) {
                this.sof.setErrCode(errorCode.SOR_CertNotFountErr);
                return null;
            }
            try {
                return Base64Utils.encode(this.sof.getEncCert().getEncoded());
            }
            catch (Exception e) {
                this.sof.setErrCode(errorCode.SOR_ObjErr);
                return null;
            }
        }
        if (certUsage == 2) {
            if (!this.judgeInputisNull(this.sof.getSignCert())) {
                this.sof.setErrCode(errorCode.SOR_CertNotFountErr);
                return null;
            }
            try {
                return Base64Utils.encode(this.sof.getSignCert().getEncoded());
            }
            catch (Exception e) {
                this.sof.setErrCode(errorCode.SOR_ObjErr);
                return null;
            }
        }
        this.sof.setErrCode(errorCode.SOR_IndataErr);
        return null;
    }

    public String SOF_genRandom(short RandomLen) {
        if (!this.judgeInputLength(RandomLen, 1, 4096)) {
            this.sof.setErrCode(errorCode.SOR_IndataErr);
            return null;
        }
        try {
            GenRandomReq genRandomReq = new GenRandomReq(RandomLen);
            SvsRequest svsRequest = new SvsRequest(ApiMethodId.GEN_RANDOM_REQ.value(), genRandomReq);
            ASN1Sequence sequence = SocketFactory.sendAndreceiveBody(this.sof, "SOF_genRandom", svsRequest.getEncoded());
            if (sequence == null) {
                return null;
            }
            GenRandomResp genRandomResp = new GenRandomResp(sequence.getObjectAt(2));
            if (genRandomResp.getRespValue().getValue().intValue() != 0) {
                this.sof.setErrCode(errorCode.SOR_GenRandErr);
                return null;
            }
            if (genRandomResp.getData() == null) {
                this.sof.setErrCode(errorCode.SOR_GenRandErr);
                return null;
            }
            return Base64Utils.encode(genRandomResp.getData().getOctets());
        }
        catch (Exception e) {
            this.sof.setErrCode(errorCode.SOR_ObjErr);
            return null;
        }
    }

    public String SOF_getCertInfo(String base64EncodeCert, int type) {
        if (!this.judgeInputisNull(base64EncodeCert)) {
            this.sof.setErrCode(errorCode.SOR_IndataErr);
            return null;
        }
        if (!this.judgeisBase64(base64EncodeCert)) {
            this.sof.setErrCode(errorCode.SOR_CERTENCODEErr);
            return null;
        }
        int[] types = new int[]{1, 2, 5, 6, 7, 8, 9, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 28, 33, 34, 35, 49, 50, 51, 52};
        boolean flag = false;
        for (int i = 0; i < types.length; ++i) {
            if (type != types[i]) continue;
            if (type > 52) {
                this.sof.setErrCode(errorCode.SOR_NotSupportYetErr);
                return null;
            }
            flag = true;
            break;
        }
        if (!flag) {
            this.sof.setErrCode(errorCode.SOR_NotSupportYetErr);
            return null;
        }
        try {
            ParseCertReq parseCertReq = new ParseCertReq(type, Base64Utils.decode(base64EncodeCert));
            SvsRequest svsRequest = new SvsRequest(ApiMethodId.PARSE_CERT.value(), parseCertReq);
            ASN1Sequence sequence = SocketFactory.sendAndreceiveBody(this.sof, "SOF_getCertInfo", svsRequest.getEncoded());
            if (sequence == null) {
                return null;
            }
            ParseCertResp parseCertResp = new ParseCertResp(sequence.getObjectAt(2));
            if (parseCertResp.getRespValue().getValue().intValue() != 0) {
                this.sof.setErrCode(errorCode.SOR_PARAMETERNOTSUPPORTErr);
                return null;
            }
            if (parseCertResp.getData() == null) {
                this.sof.setErrCode(errorCode.SOR_CertNotFountErr);
                return null;
            }
            switch (type) {
                case 1: {
                    int i = ASN1Integer.getInstance((Object)parseCertResp.getData().getOctets()).getValue().intValue();
                    if (i == 0) {
                        return String.valueOf(1);
                    }
                    if (i == 1) {
                        return String.valueOf(2);
                    }
                    return String.valueOf(3);
                }
                case 2: {
                    return String.valueOf(ASN1Integer.getInstance((Object)parseCertResp.getData().getOctets()));
                }
                case 5: 
                case 7: {
                    return String.valueOf(X500Name.getInstance((Object)parseCertResp.getData().getOctets()));
                }
                case 6: {
                    return DateObject.getInstance(parseCertResp.getData().getOctets()).toString();
                }
                case 8: {
                    return Functions.toHexString(parseCertResp.getData().getOctets());
                }
                case 9: {
                    return String.valueOf(parseCertResp.getData().getOctets());
                }
            }
            this.sof.setErrCode(errorCode.SOR_PARAMETERNOTSUPPORTErr);
            return null;
        }
        catch (Exception e) {
            this.sof.setErrCode(errorCode.SOR_ObjErr);
            return null;
        }
    }

    public String SOF_getCertInfoByOid(String base64EncodeCert, String oid) {
        if (!this.judgeInputisNull(base64EncodeCert) || !this.judgeInputisNull(oid)) {
            this.sof.setErrCode(errorCode.SOR_IndataErr);
            return null;
        }
        if (!this.judgeisBase64(base64EncodeCert)) {
            this.sof.setErrCode(errorCode.SOR_CERTENCODEErr);
            return null;
        }
        X509Certificate x509Certificate = ConvertPublicKeyFrombyte.readCertificateFromCerByte(Base64Utils.decode(base64EncodeCert));
        if (!this.judgeInputisNull(x509Certificate)) {
            this.sof.setErrCode(errorCode.SOR_CERTENCODEErr);
            return null;
        }
        byte[] extensionValue = x509Certificate.getExtensionValue(oid);
        if (!this.judgeInputisNull(extensionValue)) {
            this.sof.setErrCode(errorCode.SOR_NotSupportYetErr);
            return null;
        }
        return extensionValue.toString();
    }

    public int SOF_validateCert(String base64EncodeCert) {
        if (!this.judgeInputisNull(base64EncodeCert)) {
            this.sof.setErrCode(errorCode.SOR_IndataErr);
            return -6;
        }
        if (!this.judgeisBase64(base64EncodeCert)) {
            this.sof.setErrCode(errorCode.SOR_IndataErr);
            return -6;
        }
        ValidateCertResp validateCertResp = null;
        try {
            X509Certificate x509Certificate = ConvertPublicKeyFrombyte.readCertificateFromCerByte(Base64Utils.decode(base64EncodeCert));
            if (x509Certificate == null) {
                this.sof.setErrCode(errorCode.SOR_CERTENCODEErr);
                return -6;
            }
            ValidateCertReq validateCertReq = new ValidateCertReq(x509Certificate, this.sof.getOcsp());
            SvsRequest svsRequest = new SvsRequest(ApiMethodId.VALIDATE_CERT.value(), validateCertReq);
            ASN1Sequence sequence = SocketFactory.sendAndreceiveBody(this.sof, "SOF_validateCert", svsRequest.getEncoded());
            if (sequence == null) {
                return -6;
            }
            validateCertResp = new ValidateCertResp(sequence.getObjectAt(2));
        }
        catch (CertificateException e) {
            this.sof.setErrCode(errorCode.SOR_CERTENCODEErr);
            return -6;
        }
        catch (NoSuchProviderException e) {
            this.sof.setErrCode(errorCode.SOR_CERTENCODEErr);
            return -6;
        }
        catch (Exception e) {
            this.sof.setErrCode(errorCode.SOR_ObjErr);
            return -6;
        }
        if (validateCertResp.getRespValue().getValue().intValue() != 0) {
            if (!this.sof.getOcsp()) {
                switch (validateCertResp.getRespValue().getValue().intValue()) {
                    case 0: {
                        return 1;
                    }
                    case 0x4000009: {
                        this.sof.setErrCode(errorCode.SOR_CERTHASEXPIREDErr);
                        return -2;
                    }
                    case 0x400000A: {
                        this.sof.setErrCode(errorCode.SOR_CERTHASEXPIREDErr);
                        return -5;
                    }
                    case 0x400000B: {
                        this.sof.setErrCode(errorCode.SOR_CERTREVOKEDErr);
                        return -3;
                    }
                    case 0x400000C: {
                        this.sof.setErrCode(errorCode.SOR_CERTINVALIDErr);
                        return -1;
                    }
                }
                this.sof.setErrCode(errorCode.SOR_VeryPolicyErr);
                return -6;
            }
            switch (validateCertResp.getRespValue().getValue().intValue()) {
                case 0x4000007: {
                    this.sof.setErrCode(errorCode.SOR_CERTREVOKEDErr);
                    return -3;
                }
            }
            this.sof.setErrCode(errorCode.SOR_VeryPolicyErr);
            return -6;
        }
        if (this.sof.getOcsp()) {
            switch (validateCertResp.getState().getValue().intValue()) {
                case 0: {
                    return 1;
                }
                case 1: {
                    this.sof.setErrCode(errorCode.SOR_CERTREVOKEDErr);
                    return -3;
                }
            }
            this.sof.setErrCode(errorCode.SOR_VeryPolicyErr);
            return -6;
        }
        return 1;
    }

    public String SOF_SignData(byte[] inData) {
        if (!this.judgeInputisNull(this.sof.getAppName())) {
            this.sof.setErrCode(errorCode.SOR_APPNOTFOUND);
            return null;
        }
        if (!this.judgeSignMethod(this.sof.getSignMethod())) {
            this.sof.setErrCode(errorCode.SOR_AlgoTypeErr);
            return null;
        }
        if (!this.judgeInputisNull(inData)) {
            this.sof.setErrCode(errorCode.SOR_IndataErr);
            return null;
        }
        try {
            if (inData.length > 4096) {
                byte[] signature = this.signedVerifyUtils.signedDataMulti(this.sof, inData);
                if (signature == null) {
                    return null;
                }
                return Base64Utils.encode(signature);
            }
            byte[] signature = this.signedVerifyUtils.signedData(this.sof, inData);
            if (signature == null) {
                return null;
            }
            return Base64Utils.encode(signature);
        }
        catch (Exception e) {
            this.sof.setErrCode(errorCode.SOR_ObjErr);
            return null;
        }
    }

    public boolean SOF_verifySignedData(String base64EncodeCert, String inData, String signature) {
        if (!this.judgeSignMethod(this.sof.getSignMethod())) {
            this.sof.setErrCode(errorCode.SOR_AlgoTypeErr);
            return false;
        }
        if (!this.judgeInputisNull(base64EncodeCert)) {
            this.sof.setErrCode(errorCode.SOR_IndataErr);
            return false;
        }
        if (!this.judgeisBase64(base64EncodeCert)) {
            this.sof.setErrCode(errorCode.SOR_IndataErr);
            return false;
        }
        if (!this.judgeInputisNull(inData)) {
            this.sof.setErrCode(errorCode.SOR_IndataErr);
            return false;
        }
        if (!this.judgeInputisNull(signature)) {
            this.sof.setErrCode(errorCode.SOR_IndataErr);
            return false;
        }
        if (!this.judgeisBase64(signature)) {
            this.sof.setErrCode(errorCode.SOR_IndataErr);
            return false;
        }
        if (!this.judgeVerifylevel(this.sof.getVerifylevel())) {
            this.sof.setErrCode(errorCode.SOR_IndataErr);
            return false;
        }
        try {
            if (inData.length() > 4096 ? this.signedVerifyUtils.verifySignedDataMulti(this.sof, base64EncodeCert, inData, signature) : this.signedVerifyUtils.verifySignedData(this.sof, base64EncodeCert, inData, signature)) {
                return true;
            }
        }
        catch (Exception e) {
            this.sof.setErrCode(errorCode.SOR_VERIFYSIGNDATAErr);
            return false;
        }
        return false;
    }

    public String SOF_signFile(String inFile) {
        System.out.println(this.sof);
        if (!this.judgeInputisNull(this.sof.getAppName())) {
            this.sof.setErrCode(errorCode.SOR_APPNOTFOUND);
            return null;
        }
        if (!this.judgeInputisNull(inFile)) {
            this.sof.setErrCode(errorCode.SOR_IndataErr);
            return null;
        }
        File file = new File(inFile);
        if (!file.exists()) {
            this.sof.setErrCode(errorCode.SOR_READFILEErr);
            return null;
        }
        if (!this.judgeSignMethod(this.sof.getSignMethod())) {
            this.sof.setErrCode(errorCode.SOR_AlgoTypeErr);
            return null;
        }
        byte[] hash = new byte[32];
        byte[] inData = new byte[4096];
        int len = 0;
        try {
            if (this.signedVerifyUtils.signedDataInit(this.sof, inData) != errorCode.SOR_OK) {
                return null;
            }
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(inFile));
            while ((len = in.read(inData, 0, inData.length)) != -1) {
                if (this.signedVerifyUtils.signedDataUpdate(this.sof, inData, len, hash) != errorCode.SOR_OK) {
                    this.sof.setErrCode(errorCode.SOR_SIGNDATAErr);
                    return null;
                }
                if (len >= 0) continue;
            }
            in.close();
            byte[] signature = this.signedVerifyUtils.signedDataFinal(this.sof, hash);
            if (!this.judgeInputisNull(signature)) {
                this.sof.setErrCode(errorCode.SOR_SIGNDATAErr);
                return null;
            }
            return Base64Utils.encode(signature);
        }
        catch (FileNotFoundException e) {
            this.sof.setErrCode(errorCode.SOR_READFILEErr);
            return null;
        }
        catch (Exception e) {
            this.sof.setErrCode(errorCode.SOR_SIGNDATAErr);
            return null;
        }
    }

    public boolean SOF_verifySignedFile(String base64EncodeCert, String inFile, String signature) {
        if (!this.judgeInputisNull(base64EncodeCert)) {
            this.sof.setErrCode(errorCode.SOR_IndataErr);
            return false;
        }
        if (!this.judgeisBase64(base64EncodeCert)) {
            this.sof.setErrCode(errorCode.SOR_IndataErr);
            return false;
        }
        File file = new File(inFile);
        if (!file.exists()) {
            this.sof.setErrCode(errorCode.SOR_READFILEErr);
            return false;
        }
        if (!this.judgeInputisNull(signature)) {
            this.sof.setErrCode(errorCode.SOR_IndataErr);
            return false;
        }
        if (!this.judgeisBase64(signature)) {
            this.sof.setErrCode(errorCode.SOR_IndataErr);
            return false;
        }
        if (!this.judgeSignMethod(this.sof.getSignMethod())) {
            this.sof.setErrCode(errorCode.SOR_AlgoTypeErr);
            return false;
        }
        byte[] hash = new byte[32];
        byte[] inData = new byte[4096];
        int len = 0;
        try {
            if (this.signedVerifyUtils.verifysignedDataInit(this.sof, base64EncodeCert) != errorCode.SOR_OK) {
                return false;
            }
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(inFile));
            while ((len = in.read(inData, 0, inData.length)) != -1) {
                if (this.signedVerifyUtils.verifySignedDataUpdate(this.sof, inData, len, hash) != errorCode.SOR_OK) {
                    return false;
                }
                if (len >= 0) continue;
            }
            in.close();
            return this.signedVerifyUtils.verifysignedDataFinal(this.sof, base64EncodeCert, new String(inData), signature);
        }
        catch (FileNotFoundException e) {
            this.sof.setErrCode(errorCode.SOR_READFILEErr);
            return false;
        }
        catch (Exception e) {
            this.sof.setErrCode(errorCode.SOR_VERIFYSIGNDATAErr);
            return false;
        }
    }

    public String SOF_encryptData(String base64EncodeCert, byte[] inData) {
        EncryptDataApi encryptDataApi = new EncryptDataApi();
        X509Certificate x509Certificate = ConvertPublicKeyFrombyte.readCertificateFromCerByte(Base64Utils.decode(base64EncodeCert));
        if (x509Certificate != null) {
            System.out.println("encryptData------------x509 cert :" + x509Certificate.toString());
        }
        if (inData.length <= 4096) {
            EncryptDataDto encryptDataDto = encryptDataApi.encryptDataSingle(this.sof, x509Certificate, inData);
            ASN1OctetString cipherText = encryptDataDto.getCipherText();
            ASN1OctetString symKeyText = encryptDataDto.getSymKey();
            ASN1OctetString iv = encryptDataDto.getIv();
            String baseEnveloped = Asn1Util.packEnvelopedData(x509Certificate, symKeyText.getOctets(), cipherText.getOctets(), iv, this.sof.getEncMethod());
            return baseEnveloped;
        }
        String baseEnveloped = encryptDataApi.encryptDataMulti(this.sof, x509Certificate, inData);
        return baseEnveloped;
    }

    public byte[] SOF_decryptData(String containerName, String inData) {
        byte[] originText;
        if (!this.judgeInputisNull(containerName)) {
            this.sof.setErrCode(errorCode.SOR_IndataErr);
            return null;
        }
        if (!this.judgeInputLength(containerName.length(), 0, 60)) {
            this.sof.setErrCode(errorCode.SOR_IndataLenErr);
            return null;
        }
        if (!this.judgeEncMethod(this.sof.getEncMethod())) {
            this.sof.setErrCode(errorCode.SOR_AlgoTypeErr);
            return null;
        }
        if (!this.judgeInputisNull(inData)) {
            this.sof.setErrCode(errorCode.SOR_IndataErr);
            return null;
        }
        if (!this.judgeisBase64(inData)) {
            this.sof.setErrCode(errorCode.SOR_IndataErr);
            return null;
        }
        try {
            String appName = ReadJsonConfig.ReadJsonConfig(containerName).get((Object)"appName").toString();
            if (!this.judgeInputisNull(appName)) {
                this.sof.setErrCode(errorCode.SOR_IndataErr);
                return null;
            }
            if (!appName.equals(this.sof.getAppName())) {
                this.sof.setErrCode(errorCode.SOR_IndataErr);
                return null;
            }
        }
        catch (Exception e) {
            this.sof.setErrCode(errorCode.SOR_IndataErr);
            return null;
        }
        if (inData.length() <= 4096) {
            originText = EncryptDecryptUtils.singleDecryptData(this.sof, inData.getBytes(StandardCharsets.UTF_8));
            return originText;
        }
        originText = EncryptDecryptUtils.multiDecryptData(this.sof, inData.getBytes(StandardCharsets.UTF_8));
        return originText;
    }

    public boolean SOF_encryptFile(String base64Cert, String inFile, String outFile) {
        if (!this.judgeInputisNull(base64Cert)) {
            this.sof.setErrCode(errorCode.SOR_IndataErr);
            return false;
        }
        if (!this.judgeisBase64(base64Cert)) {
            this.sof.setErrCode(errorCode.SOR_IndataErr);
            return false;
        }
        if (!this.judgeInputisNull(inFile) || !this.judgeInputisNull(outFile)) {
            this.sof.setErrCode(errorCode.SOR_IndataErr);
            return false;
        }
        if (!this.judgeEncMethod(this.sof.getEncMethod())) {
            this.sof.setErrCode(errorCode.SOR_AlgoTypeErr);
            return false;
        }
        File infile = new File(inFile);
        if (!infile.exists() || infile.length() > 4096L) {
            this.sof.setErrCode(errorCode.SOR_READFILEErr);
            return false;
        }
        File outfile = new File(outFile);
        if (outfile.exists()) {
            this.sof.setErrCode(errorCode.SOR_WRITEFILEErr);
            return false;
        }
        X509Certificate x509Certificate = ConvertPublicKeyFrombyte.readCertificateFromCerByte(Base64Utils.decode(base64Cert));
        if (!this.judgeInputisNull(x509Certificate)) {
            this.sof.setErrCode(errorCode.SOR_CERTENCODEErr);
            return false;
        }
        return EncryptDecryptUtils.fileEncrypted(this.sof, inFile, outFile, x509Certificate);
    }

    public boolean SOF_decryptFile(String containerName, String inFile, String outFile) {
        if (!this.judgeInputisNull(containerName)) {
            this.sof.setErrCode(errorCode.SOR_IndataErr);
            return false;
        }
        if (!this.judgeInputisNull(inFile) || !this.judgeInputisNull(outFile)) {
            this.sof.setErrCode(errorCode.SOR_IndataErr);
            return false;
        }
        if (!this.judgeEncMethod(this.sof.getEncMethod())) {
            this.sof.setErrCode(errorCode.SOR_AlgoTypeErr);
            return false;
        }
        File infile = new File(inFile);
        if (!infile.exists() || infile.length() > 4096L) {
            this.sof.setErrCode(errorCode.SOR_READFILEErr);
            return false;
        }
        File outfile = new File(outFile);
        if (outfile.exists()) {
            this.sof.setErrCode(errorCode.SOR_WRITEFILEErr);
            return false;
        }
        if (!new File(outfile.getParent()).exists()) {
            this.sof.setErrCode(errorCode.SOR_WRITEFILEErr);
            return false;
        }
        try {
            String appName = ReadJsonConfig.ReadJsonConfig(containerName).get((Object)"appName").toString();
            if (!this.judgeInputisNull(appName) || !appName.equals(this.sof.getAppName())) {
                this.sof.setErrCode(errorCode.SOR_IndataErr);
                return false;
            }
        }
        catch (Exception e) {
            this.sof.setErrCode(errorCode.SOR_IndataErr);
            return false;
        }
        return EncryptDecryptUtils.fileDecrypted(this.sof, inFile, outFile);
    }

    public synchronized String SOF_SignMessage(byte[] inData) {
        if (!this.judgeInputisNull(this.sof.getAppName())) {
            this.sof.setErrCode(errorCode.SOR_APPNOTFOUND);
            return null;
        }
        if (!this.judgeInputisNull(inData)) {
            this.sof.setErrCode(errorCode.SOR_IndataErr);
            return null;
        }
        if (!this.judgeInputLength(inData.length, 0, 4096)) {
            this.sof.setErrCode(errorCode.SOR_IndataLenErr);
            return null;
        }
        if (!this.judgeSignMethod(this.sof.getSignMethod())) {
            this.sof.setErrCode(errorCode.SOR_AlgoTypeErr);
            return null;
        }
        if (!this.judgeInputisNull(this.sof.getSignCert())) {
            this.sof.setErrCode(errorCode.SOR_CertNotFountErr);
            return null;
        }
        if (this.sof.getSignCert().getPublicKey().getAlgorithm().equals("RSA")) {
            long signMethod = this.sof.getSignMethod();
            if (signMethod != SvsOidEnum.SM3_RSA && signMethod != SvsOidEnum.SHA1_RSA && signMethod != SvsOidEnum.SHA256_RSA) {
                this.sof.setErrCode(errorCode.SOR_AlgoTypeErr);
                return null;
            }
        } else if (this.sof.getSignCert().getPublicKey().getAlgorithm().equals("EC") && this.sof.getSignMethod() != SvsOidEnum.SM3_SM2) {
            this.sof.setErrCode(errorCode.SOR_AlgoTypeErr);
            return null;
        }
        return this.signedVerifyUtils.signMessage(this.sof, inData);
    }

    public synchronized boolean SOF_verifySignedMessage(String signedMessage) {
        if (!this.judgeInputisNull(signedMessage)) {
            this.sof.setErrCode(errorCode.SOR_IndataErr);
            return false;
        }
        if (!this.judgeVerifylevel(this.sof.getVerifylevel())) {
            this.sof.setErrCode(errorCode.SOR_IndataErr);
            return false;
        }
        if (!this.judgeisBase64(signedMessage)) {
            this.sof.setErrCode(errorCode.SOR_IndataErr);
            return false;
        }
        try {
            byte[] original;
            byte[] signValue = Base64Utils.decode(signedMessage);
            ContentInfo contentInfo = ContentInfo.getInstance((Object)signValue);
            if (SvsOidEnum.OID_SM2.getId().equals(contentInfo.getContentType().getId())) {
                System.out.println("sm2-----OID");
                GMT0010_SignedData gmt0010SignedData = GMT0010_SignedData.getInstance(contentInfo.getContent());
                original = gmt0010SignedData.getGmt0010ContentInfo().getContent().toASN1Primitive().getEncoded();
            } else {
                SignedData signedData = SignedData.getInstance((Object)contentInfo.getContent());
                original = signedData.getEncapContentInfo().getContent().toASN1Primitive().getEncoded();
                System.out.println("pkcs7-----OID");
            }
            if (original == null) {
                return false;
            }
            String hexString = TLVTools.bytesToHex(original);
            List<TLV> tlvList = new ArrayList<TLV>();
            tlvList = TLVTools.unpack(tlvList, hexString);
            byte[] value = tlvList.get(0).getValue();
            VerifySignedMessageReq verifySignedMessageReq = new VerifySignedMessageReq(value.length, value, signValue, false, true, true, false, false);
            SvsRequest svsRequest = new SvsRequest(ApiMethodId.VERIFY_SIGNED_MESSAGE.value(), verifySignedMessageReq);
            ASN1Sequence sequence = SocketFactory.sendAndreceiveBody(this.sof, "SOF_verifySignedMessage", svsRequest.getEncoded());
            if (sequence == null) {
                return false;
            }
            VerifySignedMessageResp verifySignedMessageResp = new VerifySignedMessageResp(sequence.getObjectAt(2));
            if (verifySignedMessageResp.getRespValue().getValue().intValue() != 0) {
                this.sof.setErrCode(errorCode.SOR_VERIFYSIGNDATAErr);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.sof.setErrCode(errorCode.SOR_ObjErr);
            return false;
        }
    }

    public byte[] SOF_getInfoFromSignedMessage(String signedMessage, short type) {
        if (!this.judgeInputisNull(signedMessage)) {
            this.sof.setErrCode(errorCode.SOR_IndataErr);
            return null;
        }
        if (!this.judgeTypelevel(type)) {
            this.sof.setErrCode(errorCode.SOR_IndataErr);
            return null;
        }
        if (!this.judgeisBase64(signedMessage)) {
            this.sof.setErrCode(errorCode.SOR_IndataErr);
            return null;
        }
        if (!this.judgeInputLength(type, 1, 3)) {
            this.sof.setErrCode(errorCode.SOR_PARAMETERNOTSUPPORTErr);
            return null;
        }
        byte[] signMessage = null;
        try {
            signMessage = Base64Utils.decode(signedMessage);
            ASN1Encodable realSignData = ContentInfo.getInstance((Object)signMessage).getContent();
            SignedData signedData = SignedData.getInstance((Object)realSignData);
            switch (type) {
                case 1: {
                    return DEROctetString.getInstance((Object)signedData.getEncapContentInfo().getContent()).getOctets();
                }
                case 2: {
                    return signedData.getCertificates().getObjectAt(0).toASN1Primitive().getEncoded();
                }
                case 3: {
                    SignerInfo signerInfo = SignerInfo.getInstance((Object)signedData.getSignerInfos().getObjectAt(0));
                    return signerInfo.getEncryptedDigest().getOctets();
                }
            }
        }
        catch (IOException ex) {
            this.sof.setErrCode(errorCode.SOR_ObjErr);
            return null;
        }
        catch (Exception e) {
            try {
                GMT0010_SignedData gmt0010SignedData = GMT0010_SignedData.getInstance(signMessage);
                try {
                    switch (type) {
                        case 1: {
                            return DEROctetString.getInstance((Object)gmt0010SignedData.getGmt0010ContentInfo().getContent()).getOctets();
                        }
                        case 2: {
                            return gmt0010SignedData.getCertificates().getObjectAt(0).toASN1Primitive().getEncoded();
                        }
                        case 3: {
                            return GMT0010_SignerInfo.getInstance(gmt0010SignedData.getSignedInfos().getObjectAt(0)).getEncryptedDigest().getOctets();
                        }
                    }
                }
                catch (Exception ex) {
                    this.sof.setErrCode(errorCode.SOR_ObjErr);
                    return null;
                }
            }
            catch (Exception e1) {
                this.sof.setErrCode(errorCode.SOR_ObjErr);
                return null;
            }
        }
        return null;
    }

    public String SOF_signMessageDetach(byte[] inData) {
        if (!this.judgeInputisNull(inData)) {
            this.sof.setErrCode(errorCode.SOR_IndataErr);
            return null;
        }
        if (!this.judgeSignMethod(this.sof.getSignMethod())) {
            this.sof.setErrCode(errorCode.SOR_AlgoTypeErr);
            return null;
        }
        if (!this.judgeInputisNull(this.sof.getAppName())) {
            this.sof.setErrCode(errorCode.SOR_APPNOTFOUND);
            return null;
        }
        try {
            byte[] signValue = this.signedVerifyUtils.signedMessageDetch(this.sof, inData);
            if (!this.judgeInputisNull(signValue)) {
                return null;
            }
            return Base64Utils.encode(signValue);
        }
        catch (Exception e) {
            this.sof.setErrCode(errorCode.SOR_ObjErr);
            return null;
        }
    }

    public boolean SOF_verifySignedMessageDetach(byte[] inData, String signedMessage) {
        if (!this.judgeSignMethod(this.sof.getSignMethod())) {
            this.sof.setErrCode(errorCode.SOR_AlgoTypeErr);
            return false;
        }
        if (!this.judgeInputisNull(inData)) {
            this.sof.setErrCode(errorCode.SOR_IndataErr);
            return false;
        }
        if (!this.judgeInputisNull(signedMessage)) {
            this.sof.setErrCode(errorCode.SOR_IndataErr);
            return false;
        }
        if (!this.judgeisBase64(signedMessage)) {
            this.sof.setErrCode(errorCode.SOR_IndataErr);
            return false;
        }
        try {
            byte[] signMessage = Base64Utils.decode(signedMessage);
            if (!this.signedVerifyUtils.verifySignedMessageDetch(this.sof, inData, signMessage)) {
                return false;
            }
        }
        catch (Exception e) {
            this.sof.setErrCode(errorCode.SOR_VERIFYSIGNDATAErr);
            return false;
        }
        return true;
    }

    public String SOF_signDataXML(String inData) {
        if (!this.judgeInputisNull(inData) || !this.judgeInputisNull(this.sof.getAppName())) {
            this.sof.setErrCode(errorCode.SOR_IndataErr);
            return null;
        }
        if (!this.judgeInputisNull(this.sof.getSignCert())) {
            this.sof.setErrCode(errorCode.SOR_CertNotFountErr);
            return null;
        }
        if (this.sof.getXMLType() != 0 && this.sof.getXMLType() != 1 && this.sof.getXMLType() != 2) {
            this.sof.setErrCode(errorCode.SOR_IndataErr);
            return null;
        }
        try {
            XmlUtil.parseXml((String)inData);
        }
        catch (Exception e) {
            this.sof.setErrCode(errorCode.SOR_IndataErr);
            return null;
        }
        try {
            byte[] signature = this.signedVerifyUtils.signedData(this.sof, inData.getBytes());
            if (signature == null) {
                return null;
            }
            String xmlSignValue = XMLSignedVerifyUtils.signedXML(this.sof, inData, Base64Utils.encode(signature));
            if (!xmlSignValue.equals(null)) {
                return xmlSignValue;
            }
            return null;
        }
        catch (Exception e) {
            this.sof.setErrCode(errorCode.SOR_ObjErr);
            return null;
        }
    }

    public static void main(String[] args) {
        System.out.print(new SvsSofInstance().SOF_signDataXML("<name>abc</name>"));
    }

    public boolean SOF_verifySignedDataXML(String XMLSignedData) {
        try {
            Document document = DocumentHelper.parseText((String)XMLSignedData);
            String name = document.getRootElement().getName();
            System.out.println(name);
            System.out.println(document.getName());
            System.out.println(document.getText());
            System.out.println(document.getPath());
            System.out.println(document.getNodeType());
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        return true;
    }

    public String SOF_getXMLSignatureInfo(String XMLSignedData, short type) {
        return null;
    }

    public String SOF_createTimeStampRequest(byte[] inData) {
        if (!this.judgeInputisNull(inData)) {
            this.sof.setErrCode(errorCode.SOR_IndataErr);
            return null;
        }
        long signMethod = this.sof.getSignMethod();
        if (!this.judgeSignMethod(signMethod)) {
            this.sof.setErrCode(errorCode.SOR_AlgoTypeErr);
            return null;
        }
        CreateTimeStampReq createTimeStampReq = new CreateTimeStampReq();
        String timeStampReq = createTimeStampReq.CreateTimeStampReq(inData, signMethod, this.sof.isCertReq());
        if (!this.judgeInputisNull(timeStampReq)) {
            this.sof.setErrCode(errorCode.SOR_HashErr);
            System.out.println("\u65f6\u95f4\u6233\u8bf7\u6c42\u521b\u5efa\u5931\u8d25");
            return null;
        }
        System.out.println("\u65f6\u95f4\u6233\u8bf7\u6c42\u521b\u5efa\u6210\u529f");
        return timeStampReq;
    }

    public String SOF_createTimeStampResponse(String timeStampRequest) {
        if (!this.judgeInputisNull(this.sof.getAppName())) {
            this.sof.setErrCode(errorCode.SOR_APPNOTFOUND);
            return null;
        }
        if (!this.judgeInputisNull(timeStampRequest)) {
            this.sof.setErrCode(errorCode.SOR_IndataErr);
            return null;
        }
        if (!this.judgeisBase64(timeStampRequest)) {
            this.sof.setErrCode(errorCode.SOR_IndataErr);
            return null;
        }
        if (!this.judgeSignMethod(this.sof.getSignMethod())) {
            this.sof.setErrCode(errorCode.SOR_AlgoTypeErr);
            return null;
        }
        TimeStampApi TimeStamp = new TimeStampApi();
        CreateTimeStampRespResp timeStampResponse = TimeStamp.createTimeStampResponse(this.sof, timeStampRequest);
        String result = new String(timeStampResponse.getTsResp().getOctets());
        if (!this.judgeInputisNull(result)) {
            System.out.println("\u65f6\u95f4\u6233\u8bf7\u6c42\u54cd\u5e94-------\u56de\u5e94\u5f02\u5e38");
            return null;
        }
        return result;
    }

    public boolean SOF_verifyTimeStamp(String inData, String tsResponseData) {
        if (!(this.judgeInputisNull(inData) && this.judgeInputisNull(tsResponseData) && this.judgeTypelevel(this.sof.getVerifylevel()))) {
            this.sof.setErrCode(errorCode.SOR_IndataErr);
            return false;
        }
        if (!this.judgeSignMethod(this.sof.getSignMethod())) {
            this.sof.setErrCode(errorCode.SOR_AlgoTypeErr);
            return false;
        }
        TimeStampApi timeStampApi = new TimeStampApi();
        ASN1OctetString octetString = DEROctetString.getInstance((Object)tsResponseData.getBytes());
        return timeStampApi.verifyTimeStamp(this.sof, inData, octetString);
    }

    public String SOF_getTimeStampInfo(ASN1OctetString tsResponseData, short type) throws Exception {
        TimeStampApi timeStamp = new TimeStampApi();
        Map<Integer, String> result = timeStamp.parseTimeStamp(this.sof, tsResponseData);
        if (result != null && result.size() > 0) {
            return result.get(type);
        }
        return null;
    }

    public void close_socket() {
        if (this.sof.getxSession() != null) {
            SocketFactory.releaseSocketResource(this.sof.getxSession());
        }
    }

    public long SOF_getLastError() {
        if (this.sof.getErrCode() == 0L) {
            return errorCode.SOR_OK;
        }
        return this.sof.getErrCode();
    }

    public int SOF_hashInit(SofInstance sof, X509Certificate certificate, String markdId, long hashMethodId) throws Exception {
        HashApi hashApi = new HashApi();
        return hashApi.hashInit(sof, certificate, markdId, hashMethodId);
    }

    public int SOF_hashUpdate(SofInstance sof, int hashId, long hashAlg, String data) throws Exception {
        HashApi hashApi = new HashApi();
        return hashApi.hashUpdate(sof, hashId, hashAlg, data);
    }

    public byte[] SOF_hashFinal(SofInstance sof, int hashId, long hashAlg) throws Exception {
        HashApi hashApi = new HashApi();
        HashFinalResp response = hashApi.hashFinal(sof, hashId, hashAlg);
        if (response != null && response.isSuccess()) {
            return response.getHashValue().getOctets();
        }
        return null;
    }

    static {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

