/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.api;

import com.xdja.svs.Session;
import com.xdja.svs.SessionCache;
import com.xdja.svs.api.ApiInterface;
import com.xdja.svs.config.ConfigItem;
import com.xdja.svs.config.ConfigManager;
import common.ApiMethodId;
import execption.SOR_InitException;
import java.io.IOException;
import java.net.Socket;
import org.bouncycastle.asn1.ASN1Sequence;
import protocol.request.GetInstanceReq;
import protocol.response.GMT0029_RelateAppContext;
import protocol.session.SessionResp;
import socket.SocketFactory;
import utils.EmptyUtils;

public class AppInstanceApi
implements ApiInterface<GetInstanceReq, SessionResp> {
    String appName;

    public AppInstanceApi(String appName) throws SOR_InitException {
        this.appName = appName;
        this.initInstance(appName);
    }

    private void initInstance(String appName) throws SOR_InitException {
        if (EmptyUtils.isEmpty(appName)) {
            throw new SOR_InitException("app name must not be null");
        }
        if (SessionCache.getAppSession(appName) != null) {
            System.out.println("-----session cache exist-------------------");
            return;
        }
        ConfigItem configItem = ConfigManager.getInstance().getConfigItem(appName);
        Session clientSession = new Session(configItem);
        String host = clientSession.getServerIP();
        int port = clientSession.getServerPort();
        int timOut = clientSession.getTimeOut();
        Socket socketFd = null;
        try {
            socketFd = SocketFactory.getSocketConnection(host, port, timOut);
        }
        catch (IOException e) {
            throw new SOR_InitException(" connect to server error " + e.getMessage());
        }
        finally {
            if (socketFd == null) {
                throw new SOR_InitException(" socketFd is null");
            }
        }
        clientSession.setSocketFd(socketFd);
        SessionCache.putSession(clientSession);
    }

    @Override
    public GetInstanceReq request() {
        return new GetInstanceReq(this.appName);
    }

    @Override
    public SessionResp parse(ASN1Sequence response) throws Exception {
        SessionResp session = new SessionResp(response.getObjectAt(2));
        GMT0029_RelateAppContext relateAppContext = session.getAppContext();
        SessionCache.getAppSession(this.appName).setAppContext(relateAppContext);
        return session;
    }

    @Override
    public int apiCode() {
        return ApiMethodId.RELATE_APP_REQ.value();
    }

    @Override
    public Session getSession() {
        return SessionCache.getAppSession(this.appName);
    }
}

