/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.certificate;

import com.xdja.svs.config.ConfigManager;
import execption.PointerException;
import execption.SOR_ParameterNotSupportException;
import execption.SOR_ReadFileException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import org.bouncycastle.util.encoders.Base64;
import utils.EmptyUtils;

public class CertificateApi {
    private static final int MAX_LEN = 64;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean SOF_setCertTrustList(String ctlAltName, String ctlContent) throws Exception {
        this.interceptParam(ctlAltName, ctlContent);
        ConfigManager.getInstance();
        String rootPath = ConfigManager.getCertTrustPath();
        try (OutputStreamWriter fileWriter = null;){
            File file = new File(rootPath + File.separator + ctlAltName);
            if (!file.exists()) {
                file.createNewFile();
            } else {
                file.delete();
            }
            fileWriter = new FileWriter(file, false);
            fileWriter.write(ctlContent);
            fileWriter.flush();
        }
        return true;
    }

    private void interceptParam(String ctlAltName, String ctlContent) throws Exception {
        this.interceptAltName(ctlAltName);
        this.interceptCtlContent(ctlContent);
    }

    private void interceptAltName(String ctlAltName) throws Exception {
        if (EmptyUtils.isEmpty(ctlAltName)) {
            throw new PointerException("SOF_setCertTrustList : the ctlAltName input is null");
        }
        if (ctlAltName.length() > 64) {
            throw new SOR_ParameterNotSupportException("SOF_setCertTrustList : the ctlAltName length is too long, only support length less then 64!");
        }
    }

    private void interceptCtlContent(String ctlContent) throws Exception {
        if (EmptyUtils.isEmpty(ctlContent)) {
            throw new PointerException("SOF_setCertTrustList : the ctlContent input is null");
        }
        try {
            Base64.decode((String)ctlContent);
        }
        catch (Exception e) {
            throw new SOR_ParameterNotSupportException("SOF_setCertTrustList : the ctlContent is not Base64 format!");
        }
    }

    public String SOF_getCertTrustListAltNames() throws Exception {
        File[] listFiles;
        ConfigManager.getInstance();
        String rootPath = ConfigManager.getCertTrustPath();
        File certFileDir = new File(rootPath);
        if (!certFileDir.exists()) {
            throw new SOR_ReadFileException("SOF_getCertTrustListAltNames : CertTrustListAltName is not exist!");
        }
        if (!certFileDir.isDirectory()) {
            throw new SOR_ReadFileException("SOF_getCertTrustListAltNames : CertTrustListAltName is not a directory");
        }
        StringBuffer buffer = new StringBuffer();
        for (File file : listFiles = certFileDir.listFiles()) {
            if (!file.isFile()) continue;
            buffer.append(file.getName());
            buffer.append("@");
        }
        String result = buffer.toString();
        if (result.endsWith("@")) {
            result = result.substring(0, result.length() - 1);
        }
        System.out.println("\u8bc1\u4e66\u4fe1\u4efb\u5217\u8868:" + result);
        return result;
    }

    public String SOF_getCertTrustList(String ctlAltName) throws Exception {
        this.interceptAltName(ctlAltName);
        ConfigManager.getInstance();
        String rootPath = ConfigManager.getCertTrustPath();
        File file = new File(rootPath + File.separator + ctlAltName);
        if (!file.exists()) {
            throw new SOR_ReadFileException("SOF_getCertTrustList : ctlAltName is not exist!");
        }
        StringBuilder sb = new StringBuilder();
        String line = "";
        BufferedReader br = new BufferedReader(new FileReader(file));
        while ((line = br.readLine()) != null) {
            sb.append(line);
            sb.append("\n");
        }
        br.close();
        return sb.toString();
    }

    public boolean SOF_delCertTrustList(String ctlAltName) throws Exception {
        this.interceptAltName(ctlAltName);
        ConfigManager.getInstance();
        String rootPath = ConfigManager.getCertTrustPath();
        File file = new File(rootPath + File.separator + ctlAltName);
        if (!file.exists()) {
            throw new SOR_ReadFileException("SOF_delCertTrustList : ctlAltName is not exist!");
        }
        try {
            file.delete();
        }
        catch (Exception e) {
            throw new SOR_ReadFileException("SOF_delCertTrustList : ctlAltName delet is error!");
        }
        return true;
    }

    private CertificateApi() {
    }

    public static CertificateApi getInstance() {
        return CertificateApiHolder.INSTANCE;
    }

    private static class CertificateApiHolder {
        static final CertificateApi INSTANCE = new CertificateApi();

        private CertificateApiHolder() {
        }
    }
}

