/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.config;

import com.alibaba.fastjson.JSON;
import com.xdja.svs.config.Config;
import com.xdja.svs.config.ConfigItem;
import execption.ParseJsonException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import utils.EmptyUtils;

public class ConfigManager {
    private static Config cacheConfig;

    private ConfigManager() {
        this.json2Bean();
    }

    public static ConfigManager getInstance() {
        return ConfigManagerHolder.INSTANCE;
    }

    private void json2Bean() {
        String path = "D:\\IdeaProjects\\svs-java-sdk\\src\\config\\config.json";
        StringBuffer result = new StringBuffer();
        File myFile = new File(path);
        if (!myFile.exists()) {
            throw new ParseJsonException("json file is not found");
        }
        try {
            FileInputStream inputStream = new FileInputStream(path);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
            BufferedReader reader = new BufferedReader(inputStreamReader);
            String line = "";
            while ((line = reader.readLine()) != null) {
                result.append(line);
            }
            reader.close();
            inputStream.close();
            cacheConfig = (Config)JSON.parseObject((String)result.toString(), Config.class);
            System.out.println("parse json content -----success");
        }
        catch (IOException e) {
            throw new ParseJsonException("can not read json content");
        }
    }

    public static String getCertTrustPath() {
        if (cacheConfig == null) {
            throw new ParseJsonException("cacheConfig has not been initialized");
        }
        return cacheConfig.getCertTrustPath();
    }

    public ConfigItem getConfigItem(String key) {
        if (EmptyUtils.isEmpty(key)) {
            throw new ParseJsonException("param key must be not null");
        }
        if (cacheConfig == null || cacheConfig.getAppsList() == null || cacheConfig.getAppsList().isEmpty()) {
            throw new ParseJsonException("cacheConfig has not been initialized");
        }
        for (ConfigItem item : cacheConfig.getAppsList()) {
            if (!key.equals(item.getAppName())) continue;
            return item;
        }
        return cacheConfig.getAppsList().get(0);
    }

    private static class ConfigManagerHolder {
        static final ConfigManager INSTANCE = new ConfigManager();

        private ConfigManagerHolder() {
        }
    }
}

