/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.decrypt;

import common.ApiMethodId;
import common.SofInstance;
import common.SvsOidEnum;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Sequence;
import protocol.SvsRequest;
import protocol.encryption.request.MultiDecryptDataFinalReq;
import protocol.encryption.request.MultiDecryptDataInitReq;
import protocol.encryption.request.MultiDecryptDataUpdateReq;
import protocol.encryption.response.MultiDecryptDataFinalResp;
import protocol.encryption.response.MultiDecryptDataInitResp;
import protocol.encryption.response.MultiDecryptDataUpdateResp;
import socket.SocketFactory;

public class DecryptDataApi {
    public MultiDecryptDataInitResp multipleDecryptDataInit(SofInstance sof, byte[] encKey, byte[] iv) throws Exception {
        MultiDecryptDataInitReq multiDecryptDataInitReq = null;
        multiDecryptDataInitReq = sof.getEncMethod() == SvsOidEnum.SGD_SM1_CBC || sof.getEncMethod() == SvsOidEnum.SGD_SM1_OFB || sof.getEncMethod() == SvsOidEnum.SGD_SM4_OFB || sof.getEncMethod() == SvsOidEnum.SGD_SM4_CBC ? new MultiDecryptDataInitReq(sof.getKeyIndex(), sof.getKeyValue(), encKey, sof.getEncMethod(), iv) : new MultiDecryptDataInitReq(sof.getKeyIndex(), sof.getKeyValue(), encKey, sof.getEncMethod());
        ASN1Sequence sequence = this.getSequence(sof, ApiMethodId.DECRYPT_DATA_REQ_INIT, multiDecryptDataInitReq);
        MultiDecryptDataInitResp multiDecryptDataInitResp = new MultiDecryptDataInitResp(sequence.getObjectAt(2));
        return multiDecryptDataInitResp;
    }

    public MultiDecryptDataUpdateResp multipleDecryptDataUpdateResp(SofInstance sof, long symKeyID, byte[] cipherText, byte[] iv) throws Exception {
        MultiDecryptDataUpdateReq multiDecryptDataUpdateReq = null;
        multiDecryptDataUpdateReq = sof.getEncMethod() == SvsOidEnum.SGD_SM1_CBC || sof.getEncMethod() == SvsOidEnum.SGD_SM1_OFB || sof.getEncMethod() == SvsOidEnum.SGD_SM4_OFB || sof.getEncMethod() == SvsOidEnum.SGD_SM4_CBC ? new MultiDecryptDataUpdateReq(symKeyID, cipherText, iv) : new MultiDecryptDataUpdateReq(symKeyID, cipherText);
        ASN1Sequence sequence = this.getSequence(sof, ApiMethodId.DECRYPT_DATA_REQ_UPDATE, multiDecryptDataUpdateReq);
        MultiDecryptDataUpdateResp multiDecryptDataUpdateResp = new MultiDecryptDataUpdateResp(sequence.getObjectAt(2));
        return multiDecryptDataUpdateResp;
    }

    public MultiDecryptDataFinalResp multipleDecryptDataFinalResp(SofInstance sof, long symKeyID) throws Exception {
        MultiDecryptDataFinalReq multiDecryptDataUpdateReq = new MultiDecryptDataFinalReq(symKeyID);
        ASN1Sequence sequence = this.getSequence(sof, ApiMethodId.DECRYPT_DATA_REQ_FINAL, multiDecryptDataUpdateReq);
        MultiDecryptDataFinalResp multiDecryptDataFinalResp = new MultiDecryptDataFinalResp(sequence.getObjectAt(2));
        return multiDecryptDataFinalResp;
    }

    private ASN1Sequence getSequence(SofInstance sof, ApiMethodId enumMethod, ASN1Object request) throws Exception {
        SvsRequest svsRequest = new SvsRequest(enumMethod.value(), request);
        ASN1Sequence sequence = SocketFactory.sendAndreceiveBody(sof, "decryptDataInit", svsRequest.getEncoded());
        if (sequence == null) {
            throw new NullPointerException("---------response is null");
        }
        return sequence;
    }
}

