/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.encryptdata;

import cn.hutool.core.map.MapBuilder;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.RandomUtil;
import com.xdja.svs.encryptdata.EncryptDataDto;
import common.ApiMethodId;
import common.SofInstance;
import common.SvsOidEnum;
import execption.errorCode;
import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import protocol.SvsRequest;
import protocol.encryption.request.MultiEncryptDataFinalReq;
import protocol.encryption.request.MultiEncryptDataInitReq;
import protocol.encryption.request.MultiEncryptDataUpdateReq;
import protocol.encryption.request.SingleDecryptDataReq;
import protocol.encryption.request.SingleEncryptDataReq;
import protocol.encryption.response.MultiEncryptDataFinalResp;
import protocol.encryption.response.MultiEncryptDataInitResp;
import protocol.encryption.response.MultiEncryptDataUpdateResp;
import protocol.encryption.response.SingleDecryptDataResp;
import protocol.encryption.response.SingleEncryptDataResp;
import socket.SocketFactory;
import utils.Asn1Util;

public class EncryptDataApi {
    public static errorCode err = new errorCode();

    public EncryptDataDto encryptDataSingle(SofInstance sof, X509Certificate x509Certificate, byte[] inData) {
        block9: {
            long pubkeyType = 0L;
            PublicKey publicKey = x509Certificate.getPublicKey();
            if (publicKey.getAlgorithm().equals("RSA")) {
                pubkeyType = SvsOidEnum.SGD_RSA;
            } else if (publicKey.getAlgorithm().equals("EC")) {
                pubkeyType = SvsOidEnum.SGD_SM2;
            } else {
                sof.setErrCode(errorCode.SOR_CERTENCODEErr);
                return null;
            }
            byte[] randomIv = RandomUtil.randomBytes((int)16);
            SingleEncryptDataReq singleEncryptDataReq = new SingleEncryptDataReq(SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded()), pubkeyType, sof.getEncMethod(), inData, randomIv);
            SvsRequest svsRequest = new SvsRequest(ApiMethodId.SINGLE_ENCRYPT_DATA_REQ.value(), singleEncryptDataReq);
            try {
                ASN1Sequence sequence = SocketFactory.sendAndreceiveBody(sof, "SOF_encryptData", svsRequest.getEncoded());
                if (sequence != null) {
                    SingleEncryptDataResp singleEncryptDataResp = new SingleEncryptDataResp((int)sof.getEncMethod(), sequence.getObjectAt(2));
                    if (singleEncryptDataResp.isSuccess()) {
                        EncryptDataDto encryptDataDto = new EncryptDataDto();
                        encryptDataDto.setCipherText(singleEncryptDataResp.getCipherText());
                        encryptDataDto.setSymKey(singleEncryptDataResp.getSymKey());
                        encryptDataDto.setIv(singleEncryptDataResp.getIv());
                        return encryptDataDto;
                    }
                    break block9;
                }
                return null;
            }
            catch (IOException e) {
                sof.setErrCode(errorCode.SOR_ObjErr);
            }
            catch (Exception e) {
                sof.setErrCode(errorCode.SOR_ProviderTypeErr);
            }
        }
        return null;
    }

    public String encryptDataMulti(SofInstance sof, X509Certificate x509Certificate, byte[] inData) {
        try {
            MultiEncryptDataInitResp multiEncryptDataInitResp = this.multipleEncryptDataInit(sof, x509Certificate);
            long symKeyID = multiEncryptDataInitResp.getSymKeyID().getValue().longValue();
            byte[][] split = ArrayUtil.split((byte[])inData, (int)4096);
            int len = inData.length % 4096;
            byte[] tmpIndata = new byte[len];
            MultiEncryptDataUpdateResp multiEncryptDataUpdateResp = null;
            int length = split.length;
            MapBuilder builder = MapUtil.builder();
            Map build = builder.build();
            for (int i = 0; i < length - 1; ++i) {
                ASN1OctetString iv;
                if (i == 0) {
                    iv = multiEncryptDataInitResp.getIv();
                    multiEncryptDataUpdateResp = this.multipleEncryptDataUpdate(sof, symKeyID, split[i], iv);
                    build.put(i, multiEncryptDataUpdateResp.getCipherText().getOctets());
                    continue;
                }
                iv = multiEncryptDataUpdateResp.getIv();
                multiEncryptDataUpdateResp = this.multipleEncryptDataUpdate(sof, symKeyID, split[i], iv);
                build.put(i, multiEncryptDataUpdateResp.getCipherText().getOctets());
            }
            ArrayUtil.copy((Object)split[length - 1], (Object)tmpIndata, (int)len);
            MultiEncryptDataFinalResp multiEncryptDataFinalResp = this.multipleEncryptDataFinal(sof, symKeyID, tmpIndata, multiEncryptDataUpdateResp.getIv());
            build.put(length - 1, multiEncryptDataFinalResp.getCipherText().getOctets());
            byte[] Ciphertext = new byte[inData.length];
            for (int j = 0; j < build.size(); ++j) {
                if (j == build.size() - 1) {
                    System.arraycopy(tmpIndata, 0, Ciphertext, 4096 * j, tmpIndata.length);
                    continue;
                }
                System.arraycopy(build.get(j), 0, Ciphertext, 4096 * j, 4096);
            }
            String baseEnveloped = Asn1Util.packEnvelopedData(x509Certificate, multiEncryptDataInitResp.getSymKey().getOctets(), Ciphertext, multiEncryptDataFinalResp.getIv(), sof.getEncMethod());
            if (baseEnveloped == null) {
                sof.setErrCode(errorCode.SOR_PKCS7ENCODEErr);
                return null;
            }
            return baseEnveloped;
        }
        catch (Exception e) {
            sof.setErrCode(errorCode.SOR_ENCRYPTDATAErr);
            return null;
        }
    }

    public String decryptDataSingle(SofInstance sof, int keyIndex, String passWd, long symAlgo, ASN1OctetString symKey, ASN1OctetString cipherText, ASN1OctetString iv) throws Exception {
        SingleDecryptDataResp encryptDataResp;
        SingleDecryptDataReq singleDecryptDataReq = new SingleDecryptDataReq(keyIndex, passWd, symAlgo, symKey, cipherText, iv.getOctets());
        SvsRequest svsRequest = new SvsRequest(ApiMethodId.SINGLE_DECRYPT_DATA_REQ.value(), singleDecryptDataReq);
        ASN1Sequence sequence = SocketFactory.sendAndreceiveBody(sof, "SOF_decryptData", svsRequest.getEncoded());
        if (sequence != null && (encryptDataResp = new SingleDecryptDataResp(sequence.getObjectAt(2))).isSuccess()) {
            return encryptDataResp.getPlainData();
        }
        return null;
    }

    public MultiEncryptDataInitResp multipleEncryptDataInit(SofInstance sof, X509Certificate x509Certificate) throws Exception {
        MultiEncryptDataInitReq multiEncryptDataInitReq = new MultiEncryptDataInitReq(SubjectPublicKeyInfo.getInstance((Object)x509Certificate.getPublicKey().getEncoded()), sof.getEncMethod());
        ASN1Sequence sequence = this.getSequence(sof, ApiMethodId.ENCRYPT_DATA_REQ_INIT, multiEncryptDataInitReq);
        MultiEncryptDataInitResp multiEncryptDataInitResp = new MultiEncryptDataInitResp((int)sof.getEncMethod(), sequence.getObjectAt(2));
        return multiEncryptDataInitResp;
    }

    public MultiEncryptDataUpdateResp multipleEncryptDataUpdate(SofInstance sof, long symKeyID, byte[] inData, ASN1OctetString iv) throws Exception {
        MultiEncryptDataUpdateReq multiEncryptDataUpdateReq = new MultiEncryptDataUpdateReq(symKeyID, inData, iv);
        ASN1Sequence sequence = this.getSequence(sof, ApiMethodId.ENCRYPT_DATA_REQ_UPDATE, multiEncryptDataUpdateReq);
        MultiEncryptDataUpdateResp multiEncryptDataUpdateResp = new MultiEncryptDataUpdateResp((int)sof.getEncMethod(), sequence.getObjectAt(2));
        return multiEncryptDataUpdateResp;
    }

    public MultiEncryptDataFinalResp multipleEncryptDataFinal(SofInstance sof, long symKeyID, byte[] inData, ASN1OctetString iv) throws Exception {
        MultiEncryptDataFinalReq multiEncryptDataFinalReq = new MultiEncryptDataFinalReq(symKeyID, inData, iv);
        ASN1Sequence sequence = this.getSequence(sof, ApiMethodId.ENCRYPT_DATA_REQ_FINAL, multiEncryptDataFinalReq);
        MultiEncryptDataFinalResp multiEncryptDataFinalResp = new MultiEncryptDataFinalResp(sequence.getObjectAt(2));
        return multiEncryptDataFinalResp;
    }

    private ASN1Sequence getSequence(SofInstance sof, ApiMethodId enumMethod, ASN1Object request) throws Exception {
        SvsRequest svsRequest = new SvsRequest(enumMethod.value(), request);
        ASN1Sequence sequence = SocketFactory.sendAndreceiveBody(sof, "encryptDataUpdata", svsRequest.getEncoded());
        if (sequence == null) {
            throw new NullPointerException("---------response is null");
        }
        return sequence;
    }
}

