/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.hash;

import common.ApiMethodId;
import common.SofInstance;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import protocol.SvsRequest;
import protocol.hash.request.HashFinalReq;
import protocol.hash.request.HashInitReq;
import protocol.hash.request.HashUpdateReq;
import protocol.hash.response.HashFinalResp;
import protocol.hash.response.HashInitResp;
import protocol.hash.response.HashUpdateResp;
import socket.SocketFactory;

public class HashApi {
    public int hashInit(SofInstance sof, X509Certificate certificate, String markdId, long hashMethodId) throws Exception {
        PublicKey publicKey = certificate.getPublicKey();
        HashInitReq hashInitReq = new HashInitReq(hashMethodId, SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded()), markdId);
        SvsRequest svsRequest = new SvsRequest(ApiMethodId.HASH_INIT_REQ.value(), hashInitReq);
        ASN1Sequence sequence = SocketFactory.sendAndreceiveBody(sof, "hashInit", svsRequest.getEncoded());
        if (sequence != null) {
            HashInitResp hashInitResp = new HashInitResp(sequence.getObjectAt(2));
            return hashInitResp.getHashId().getValue().intValue();
        }
        return -1;
    }

    public int hashUpdate(SofInstance sof, int hashId, long hashAlg, String data) throws Exception {
        HashUpdateReq hashUpdateReq = new HashUpdateReq(hashId, hashAlg, data.getBytes());
        SvsRequest svsRequest = new SvsRequest(ApiMethodId.HASH_UPDATE_REQ.value(), hashUpdateReq);
        ASN1Sequence sequence = SocketFactory.sendAndreceiveBody(sof, "hashUpdate", svsRequest.getEncoded());
        if (sequence != null) {
            HashUpdateResp hashInitResp = new HashUpdateResp(sequence.getObjectAt(2));
            return hashInitResp.getRespValue().getValue().intValue();
        }
        return -1;
    }

    public HashFinalResp hashFinal(SofInstance sof, int hashId, long hashAlg) throws Exception {
        HashFinalReq hashFinalReq = new HashFinalReq(hashId, hashAlg);
        SvsRequest svsRequest = new SvsRequest(ApiMethodId.HASH_FINAL_REQ.value(), hashFinalReq);
        ASN1Sequence sequence = SocketFactory.sendAndreceiveBody(sof, "hashUpdate", svsRequest.getEncoded());
        if (sequence != null) {
            HashFinalResp hashFinalResp = new HashFinalResp(sequence.getObjectAt(2));
            System.out.println("the result of HashFinalResp is :" + hashFinalResp.getHashValue());
            return hashFinalResp;
        }
        return null;
    }
}

