/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.timestamp;

import common.ApiMethodId;
import common.SofInstance;
import common.SvsOidEnum;
import encapsulation.GMT0010_SignedData;
import encapsulation.GMT0010_SignerInfo;
import execption.errorCode;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.SignedData;
import org.bouncycastle.asn1.tsp.TimeStampResp;
import protocol.SvsRequest;
import protocol.response.CreateTimeStampRespResp;
import protocol.response.VerifyTimeStampResp;
import protocol.timestamp.CreateTimeStampRespReq;
import protocol.timestamp.VerifyTimeStampReq;
import socket.SocketFactory;
import utils.Base64Utils;

public class TimeStampApi {
    final int TIME_STAMP_KEY = 1;
    final int TIME_STAMP_SIGN_KEY = 2;
    final int TIME_STAMP_SIGN_CERT_KEY = 3;

    public CreateTimeStampRespResp createTimeStampResponse(SofInstance sof, String base64tsReq) {
        try {
            CreateTimeStampRespReq createTimeStampRespReq = new CreateTimeStampRespReq(Base64Utils.decode(base64tsReq), sof.getSignMethod(), sof.getKeyIndex(), sof.getKeyValue());
            SvsRequest svsRequest = new SvsRequest(ApiMethodId.CREATE_TIMESTAMP_RESP_REQ.value(), createTimeStampRespReq);
            ASN1Sequence sequence = SocketFactory.sendAndreceiveBody(sof, "createTimeStampResponse", svsRequest.getEncoded());
            if (sequence == null) {
                return null;
            }
            CreateTimeStampRespResp createTimeStampRespResp = new CreateTimeStampRespResp(sequence.getObjectAt(2));
            if (createTimeStampRespResp.isSuccess()) {
                return createTimeStampRespResp;
            }
        }
        catch (Exception e) {
            System.out.println("--------------" + e.getMessage());
        }
        return null;
    }

    public boolean verifyTimeStamp(SofInstance sof, String inData, ASN1OctetString asn1OctetString) {
        try {
            TimeStampResp response = TimeStampResp.getInstance((Object)asn1OctetString.getOctets());
            boolean isCert = false;
            Object certificate = null;
            if (response.getTimeStampToken().getContentType().equals((Object)SvsOidEnum.signedData)) {
                SignedData signedData = SignedData.getInstance((Object)response.getTimeStampToken().getContent());
                int size = signedData.getCertificates().size();
                if (size > 0) {
                    isCert = true;
                }
            } else if (response.getTimeStampToken().getContentType().equals((Object)PKCSObjectIdentifiers.signedData)) {
                isCert = SignedData.getInstance((Object)asn1OctetString.getOctets()).getCertificates().size() > 0;
            } else {
                sof.setErrCode(errorCode.SOR_PKCS7ENCODEErr);
                return false;
            }
            VerifyTimeStampReq verifyTimeStampReq = null;
            if (isCert) {
                verifyTimeStampReq = new VerifyTimeStampReq(asn1OctetString.getOctets(), sof.getSignMethod(), sof.getVerifylevel(), null);
            } else {
                verifyTimeStampReq = new VerifyTimeStampReq(asn1OctetString.getOctets(), sof.getSignMethod(), sof.getVerifylevel(), null);
                if (sof.getSignCert().getEncoded().equals(null)) {
                    sof.setErrCode(errorCode.SOR_CertNotFountErr);
                    return false;
                }
                verifyTimeStampReq = new VerifyTimeStampReq(asn1OctetString.getOctets(), sof.getSignMethod(), sof.getVerifylevel(), sof.getSignCert());
            }
            SvsRequest svsRequest = new SvsRequest(ApiMethodId.VERIFY_TIMESTAMP_REQ.value(), verifyTimeStampReq);
            ASN1Sequence sequence = SocketFactory.sendAndreceiveBody(sof, "verifyTimeStamp", svsRequest.getEncoded());
            if (sequence == null) {
                return false;
            }
            VerifyTimeStampResp verifyTimeStampResp = new VerifyTimeStampResp(sequence.getObjectAt(2));
            if (verifyTimeStampResp.getRespValue().getValue().longValue() != 0L) {
                System.out.println("\u65f6\u95f4\u6233\u9a8c\u8bc1\u6536\u5230\u670d\u52a1\u5668\u56de\u5e94------------\u56de\u5e94\u5f02\u5e38");
                return false;
            }
            System.out.println("\u65f6\u95f4\u6233\u9a8c\u8bc1\u6536\u5230\u670d\u52a1\u5668\u56de\u5e94------------\u56de\u5e94\u6b63\u5e38");
            return true;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return false;
        }
    }

    public Map<Integer, String> parseTimeStamp(SofInstance sof, ASN1OctetString asn1OctetString) throws Exception {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "");
        result.put(2, "");
        result.put(3, "");
        TimeStampResp response = TimeStampResp.getInstance((Object)asn1OctetString.getOctets());
        int status = response.getStatus().getStatus().intValue();
        if (status == 0) {
            if (response.getTimeStampToken().getContentType().equals((Object)SvsOidEnum.signedData)) {
                GMT0010_SignedData instance = GMT0010_SignedData.getInstance(response.getTimeStampToken().getContent());
                byte[] origin = instance.getGmt0010ContentInfo().getContent().toASN1Primitive().getEncoded();
                result.put(1, new String(origin));
                byte[] signValue = GMT0010_SignerInfo.getInstance(instance.getSignedInfos().getObjectAt(0)).getEncryptedDigest().getOctets();
                result.put(2, Base64Utils.encode(signValue));
                byte[] cert = instance.getCertificates().getObjectAt(0).toASN1Primitive().getEncoded();
                result.put(3, Base64Utils.encode(cert));
            } else if (response.getTimeStampToken().getContentType().equals((Object)PKCSObjectIdentifiers.signedData)) {
                org.bouncycastle.asn1.cms.SignedData signedData = org.bouncycastle.asn1.cms.SignedData.getInstance((Object)response.getTimeStampToken().getContent());
                byte[] origin = signedData.getEncapContentInfo().getContent().toASN1Primitive().getEncoded();
                result.put(1, new String(origin));
                byte[] signValue = SignerInfo.getInstance((Object)signedData.getSignerInfos().getObjectAt(0)).getEncryptedDigest().getOctets();
                result.put(2, Base64Utils.encode(signValue));
                byte[] cert = signedData.getCertificates().getObjectAt(0).toASN1Primitive().getEncoded();
                result.put(3, Base64Utils.encode(cert));
            }
            return result;
        }
        return result;
    }
}

