/*
 * Decompiled with CFR 0.152.
 */
package common;

import java.io.ByteArrayInputStream;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Base64;

public class CertUtil {
    public static final String CERT_HEAD = "-----BEGIN CERTIFICATE-----";
    public static final String CERT_TAIL = "-----END CERTIFICATE-----";

    public static X509Certificate getCertFromStr16(String str) {
        byte[] bs = CertUtil.hex2byte(str);
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            ByteArrayInputStream inStream = new ByteArrayInputStream(bs);
            X509Certificate x509Cert = (X509Certificate)cf.generateCertificate(inStream);
            return x509Cert;
        }
        catch (Exception var5) {
            return null;
        }
    }

    public static byte[] hex2byte(String str) {
        if (null != str && !str.equals("")) {
            StringBuffer sb = new StringBuffer(str = str.trim());
            int len = sb.length();
            if (len != 0 && len % 2 != 1) {
                byte[] b = new byte[len / 2];
                try {
                    for (int i = 0; i < len; i += 2) {
                    }
                    return b;
                }
                catch (Exception var5) {
                    return null;
                }
            }
            return null;
        }
        return null;
    }

    public static String getPubKey(String str, int caAlg) {
        String pubKey;
        System.out.println("\u8fdb\u5165CertUtil->getPubKey: str:\n" + str);
        X509Certificate x509Cert = CertUtil.getCertFromStr(str);
        if (caAlg == 1) {
            RSAPublicKey rsa = (RSAPublicKey)x509Cert.getPublicKey();
            pubKey = rsa.getModulus().toString(16).toUpperCase();
        } else {
            ECPublicKey sm2 = (ECPublicKey)x509Cert.getPublicKey();
            System.out.println("sm2 === " + sm2);
            pubKey = sm2.getW().getAffineX().toString(16) + "#" + sm2.getW().getAffineY().toString(16);
        }
        return pubKey;
    }

    public static X509Certificate getCertFromStr(String str) {
        str = str.replace(CERT_HEAD, "").replace(CERT_TAIL, "");
        str = str.replace("\r", "").replace("\n", "");
        X509Certificate x509Cert = CertUtil.getCertFromB64(str = str.replace("\\r", "").replace("\\n", ""));
        if (x509Cert == null) {
            x509Cert = CertUtil.getCertFromFullStr(str);
        }
        if (x509Cert == null) {
            x509Cert = CertUtil.getCertFromStr16(str);
        }
        return x509Cert;
    }

    public static List<X509Certificate> getCertListFromB64(byte[] info) {
        CertificateFactory cf = null;
        List certificates = null;
        try {
            ByteArrayInputStream inStream = new ByteArrayInputStream(info);
            cf = CertificateFactory.getInstance("X.509", (Provider)new BouncyCastleProvider());
            certificates = (List)cf.generateCertificates(inStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        certificates = CertUtil.sortCerts(certificates);
        return certificates;
    }

    public static List sortCerts(List certs) {
        int i;
        if (certs.size() < 2) {
            return certs;
        }
        X500Principal issuer = ((X509Certificate)certs.get(0)).getIssuerX500Principal();
        boolean okay = true;
        for (int i2 = 1; i2 != certs.size(); ++i2) {
            X509Certificate cert = (X509Certificate)certs.get(i2);
            if (!issuer.equals(cert.getSubjectX500Principal())) {
                okay = false;
                break;
            }
            issuer = ((X509Certificate)certs.get(i2)).getIssuerX500Principal();
        }
        if (okay) {
            return certs;
        }
        ArrayList<X509Certificate> retList = new ArrayList<X509Certificate>(certs.size());
        ArrayList orig = new ArrayList(certs);
        for (i = 0; i < certs.size(); ++i) {
            X509Certificate cert = (X509Certificate)certs.get(i);
            boolean found = false;
            X500Principal subject = cert.getSubjectX500Principal();
            for (int j = 0; j != certs.size(); ++j) {
                X509Certificate c = (X509Certificate)certs.get(j);
                if (!c.getIssuerX500Principal().equals(subject)) continue;
                found = true;
                break;
            }
            if (found) continue;
            retList.add(cert);
            certs.remove(i);
        }
        block3: for (i = 0; i != retList.size(); ++i) {
            issuer = ((X509Certificate)retList.get(i)).getIssuerX500Principal();
            for (int j = 0; j < certs.size(); ++j) {
                X509Certificate c = (X509Certificate)certs.get(j);
                if (!issuer.equals(c.getSubjectX500Principal())) continue;
                retList.add(c);
                certs.remove(j);
                continue block3;
            }
        }
        if (certs.size() > 0) {
            return orig;
        }
        return retList;
    }

    public static X509Certificate getCertFromFullStr(String str) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            ByteArrayInputStream inStream = new ByteArrayInputStream(str.getBytes());
            X509Certificate x509Cert = (X509Certificate)cf.generateCertificate(inStream);
            return x509Cert;
        }
        catch (Exception var4) {
            System.err.println("getCertFromFullStr error: " + var4.toString());
            return null;
        }
    }

    public static synchronized X509Certificate getCertFromB64(String b64) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            byte[] bsCert = Base64.decode((String)b64);
            ByteArrayInputStream inStream = new ByteArrayInputStream(bsCert);
            X509Certificate x509Cert = (X509Certificate)cf.generateCertificate(inStream);
            return x509Cert;
        }
        catch (Exception var5) {
            System.err.println("getCertFromB64 error: " + var5.toString());
            return null;
        }
    }

    public static String getSn(X509Certificate cert) {
        return cert.getSerialNumber().toString(16).toLowerCase();
    }

    public static String certToFullB64(Certificate cert) {
        String certb64 = "";
        try {
            certb64 = CertUtil.bytesToFullB64(cert.getEncoded());
        }
        catch (Exception var3) {
            System.err.println("certToFullB64 error:" + var3.toString());
        }
        return certb64;
    }

    public static String bytesToFullB64(byte[] certder) {
        try {
            String certb64 = new String(Base64.encode((byte[])certder));
            certb64 = "-----BEGIN CERTIFICATE-----\n" + certb64 + "\n-----END CERTIFICATE-----\n";
            return certb64;
        }
        catch (Exception var3) {
            System.err.println("certDerToFullB64 error:" + var3.toString());
            return null;
        }
    }

    public static byte[] fillByteArrayWithZeroInHead(byte[] ss) {
        return CertUtil.fillByteArrayWithZeroInHead(ss, 64);
    }

    public static byte[] fillByteArrayWithZeroInHead(byte[] ss, int len) {
        byte[] bs = new byte[len];
        Arrays.fill((byte[])bs, (byte)0);
        System.arraycopy(ss, 0, bs, len - ss.length, ss.length);
        return bs;
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

