/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.GMSSLByteArrayUtils;
import java.math.BigInteger;
import java.security.interfaces.ECPublicKey;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;

public class SdfECCPublicKey {
    private byte[] x;
    private byte[] y;

    public static SdfECCPublicKey getInstance(ECPublicKey ecPublicKey) {
        return new SdfECCPublicKey(GMSSLByteArrayUtils.asUnsignedByteArray32(ecPublicKey.getW().getAffineX()), GMSSLByteArrayUtils.asUnsignedByteArray32(ecPublicKey.getW().getAffineY()));
    }

    public static SdfECCPublicKey getInstance(BigInteger x, BigInteger y) {
        return new SdfECCPublicKey(GMSSLByteArrayUtils.asUnsignedByteArray32(x), GMSSLByteArrayUtils.asUnsignedByteArray32(y));
    }

    public static SdfECCPublicKey getInstanceFilterHead(byte[] x, byte[] y) {
        return new SdfECCPublicKey(GMSSLByteArrayUtils.filterByteArrayZeroInHead(x), GMSSLByteArrayUtils.filterByteArrayZeroInHead(y));
    }

    public static SdfECCPublicKey getInstanceFilterFoot(byte[] x, byte[] y) {
        return new SdfECCPublicKey(GMSSLByteArrayUtils.filterByteArrayZeroInFoot(x), GMSSLByteArrayUtils.filterByteArrayZeroInFoot(y));
    }

    public SdfECCPublicKey(byte[] x, byte[] y) {
        this.x = x;
        this.y = y;
    }

    public byte[] getX() {
        return this.x;
    }

    public void setX(byte[] x) {
        this.x = x;
    }

    public byte[] getY() {
        return this.y;
    }

    public void setY(byte[] y) {
        this.y = y;
    }

    public String Base64encode() {
        byte[] all = new byte[128];
        System.arraycopy(this.x, 0, all, 0, 64);
        System.arraycopy(this.y, 0, all, 64, 64);
        return Base64.toBase64String((byte[])all);
    }

    public String toString() {
        return Hex.toHexString((byte[])this.x) + Hex.toHexString((byte[])this.y);
    }
}

