/*
 * Decompiled with CFR 0.152.
 */
package encapsulation;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERSequence;
import org.bouncycastle.asn1.BERTaggedObject;

public class GMT0010_ContentInfo
extends ASN1Object {
    private ASN1ObjectIdentifier contentType;
    private ASN1Encodable content;

    public static GMT0010_ContentInfo getInstance(Object var0) {
        if (var0 instanceof GMT0010_ContentInfo) {
            return (GMT0010_ContentInfo)((Object)var0);
        }
        return var0 != null ? new GMT0010_ContentInfo(ASN1Sequence.getInstance((Object)var0)) : null;
    }

    public static GMT0010_ContentInfo getInstance(ASN1TaggedObject var0, boolean var1) {
        return GMT0010_ContentInfo.getInstance(ASN1Sequence.getInstance((ASN1TaggedObject)var0, (boolean)var1));
    }

    public GMT0010_ContentInfo(ASN1Sequence var1) {
        if (var1.size() >= 1 && var1.size() <= 2) {
            ASN1Encodable contentType = var1.getObjectAt(0);
            this.contentType = ASN1ObjectIdentifier.getInstance((Object)contentType.toASN1Primitive());
            if (var1.size() > 1) {
                ASN1TaggedObject var2 = (ASN1TaggedObject)var1.getObjectAt(1);
                if (!var2.isExplicit() || var2.getTagNo() != 0) {
                    throw new IllegalArgumentException("Bad tag for 'content'");
                }
                this.content = var2.getObject();
            }
        } else {
            throw new IllegalArgumentException("Bad sequence size: " + var1.size());
        }
    }

    public ASN1Encodable getContent() {
        return this.content;
    }

    public ASN1ObjectIdentifier getContentType() {
        return this.contentType;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector var1 = new ASN1EncodableVector();
        var1.add((ASN1Encodable)this.contentType);
        if (this.content != null) {
            var1.add((ASN1Encodable)new BERTaggedObject(0, this.content));
        }
        return new BERSequence(var1);
    }
}

