/*
 * Decompiled with CFR 0.152.
 */
package encapsulation;

import java.nio.charset.StandardCharsets;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class GMT0010_EncryptedContentInfo
extends ASN1Object {
    private AlgorithmIdentifier contentType;
    private AlgorithmIdentifier contentencryption;
    private ASN1OctetString encryptedcontent;
    private ASN1OctetString shareInfo1;
    private ASN1OctetString shareInfo2;

    public GMT0010_EncryptedContentInfo(AlgorithmIdentifier contentType, AlgorithmIdentifier symmencMethod, byte[] encryptedcontent, String shareInfo1, String shareInfo2) {
        this.contentType = contentType;
        this.contentencryption = symmencMethod;
        this.encryptedcontent = new DEROctetString(encryptedcontent);
        this.shareInfo1 = new DEROctetString(shareInfo1.getBytes(StandardCharsets.UTF_8));
        this.shareInfo2 = new DEROctetString(shareInfo2.getBytes(StandardCharsets.UTF_8));
    }

    public GMT0010_EncryptedContentInfo(ASN1Sequence instance) throws Exception {
        ASN1InputStream asn1InputStream = new ASN1InputStream(instance.toASN1Primitive().getEncoded());
        ASN1Primitive asn1Primitive = asn1InputStream.readObject();
        if (asn1Primitive == null) {
            return;
        }
        ASN1Sequence asn1Sequence = (ASN1Sequence)asn1Primitive;
        this.contentType = AlgorithmIdentifier.getInstance((Object)asn1Sequence.getObjectAt(0));
        this.contentencryption = AlgorithmIdentifier.getInstance((Object)asn1Sequence.getObjectAt(1));
        this.encryptedcontent = DEROctetString.getInstance((Object)DERTaggedObject.getInstance((Object)asn1Sequence.getObjectAt(2)).getObject());
    }

    public static GMT0010_EncryptedContentInfo getInstance(Object var0) throws Exception {
        if (var0 instanceof GMT0010_EncryptedContentInfo) {
            return (GMT0010_EncryptedContentInfo)((Object)var0);
        }
        return var0 != null ? new GMT0010_EncryptedContentInfo(ASN1Sequence.getInstance((Object)var0)) : null;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)this.contentType);
        vector.add((ASN1Encodable)this.contentencryption);
        vector.add((ASN1Encodable)new DERTaggedObject(false, 0, (ASN1Encodable)this.encryptedcontent));
        vector.add((ASN1Encodable)new DERTaggedObject(false, 1, (ASN1Encodable)this.shareInfo1));
        vector.add((ASN1Encodable)new DERTaggedObject(false, 2, (ASN1Encodable)this.shareInfo2));
        return new DERSequence(vector);
    }

    public AlgorithmIdentifier getContentType() {
        return this.contentType;
    }

    public void setContentType(AlgorithmIdentifier contentType) {
        this.contentType = contentType;
    }

    public AlgorithmIdentifier getContentencryption() {
        return this.contentencryption;
    }

    public void setContentencryption(AlgorithmIdentifier contentencryption) {
        this.contentencryption = contentencryption;
    }

    public ASN1OctetString getEncryptedcontent() {
        return this.encryptedcontent;
    }

    public void setEncryptedcontent(ASN1OctetString encryptedcontent) {
        this.encryptedcontent = encryptedcontent;
    }

    public ASN1OctetString getShareInfo1() {
        return this.shareInfo1;
    }

    public void setShareInfo1(ASN1OctetString shareInfo1) {
        this.shareInfo1 = shareInfo1;
    }

    public ASN1OctetString getShareInfo2() {
        return this.shareInfo2;
    }

    public void setShareInfo2(ASN1OctetString shareInfo2) {
        this.shareInfo2 = shareInfo2;
    }
}

