/*
 * Decompiled with CFR 0.152.
 */
package encapsulation;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class GMT0010_RecipientInfo
extends ASN1Object {
    private ASN1Integer version;
    private IssuerAndSerialNumber issuerAndSerialNumber;
    private AlgorithmIdentifier keyEncryptionAlgorithm;
    private ASN1OctetString encryptedKey;

    public GMT0010_RecipientInfo(IssuerAndSerialNumber issuerAndSerialNumber, AlgorithmIdentifier keyEncryptionAlgorithm, byte[] encryptedKey) {
        this.version = new ASN1Integer(1L);
        this.issuerAndSerialNumber = issuerAndSerialNumber;
        this.keyEncryptionAlgorithm = keyEncryptionAlgorithm;
        this.encryptedKey = new DEROctetString(encryptedKey);
    }

    public GMT0010_RecipientInfo(ASN1Sequence var1) {
        this.version = (ASN1Integer)var1.getObjectAt(0);
        this.issuerAndSerialNumber = IssuerAndSerialNumber.getInstance((Object)var1.getObjectAt(1));
        this.keyEncryptionAlgorithm = AlgorithmIdentifier.getInstance((Object)var1.getObjectAt(2));
        this.encryptedKey = (ASN1OctetString)var1.getObjectAt(3);
    }

    public static KeyTransRecipientInfo getInstance(Object var0) {
        if (var0 instanceof KeyTransRecipientInfo) {
            return (KeyTransRecipientInfo)var0;
        }
        return var0 != null ? new KeyTransRecipientInfo(ASN1Sequence.getInstance((Object)var0)) : null;
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public IssuerAndSerialNumber getRecipientIdentifier() {
        return this.issuerAndSerialNumber;
    }

    public AlgorithmIdentifier getKeyEncryptionAlgorithm() {
        return this.keyEncryptionAlgorithm;
    }

    public ASN1OctetString getEncryptedKey() {
        return this.encryptedKey;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector var1 = new ASN1EncodableVector();
        var1.add((ASN1Encodable)this.version);
        var1.add((ASN1Encodable)this.issuerAndSerialNumber);
        var1.add((ASN1Encodable)this.keyEncryptionAlgorithm);
        var1.add((ASN1Encodable)this.encryptedKey);
        return new DERSequence(var1);
    }
}

