/*
 * Decompiled with CFR 0.152.
 */
package encapsulation;

import encapsulation.GMT0010_ContentInfo;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.cms.SignedData;

public class GMT0010_SignedData
extends ASN1Object {
    private ASN1Integer version = new ASN1Integer(1L);
    private ASN1Set digestAlgorithms;
    private GMT0010_ContentInfo gmt0010ContentInfo;
    private ASN1Set certificates;
    private ASN1Set crls;
    private ASN1Set signedInfos;

    public GMT0010_SignedData(ASN1Set digests, GMT0010_ContentInfo gmt0010ContentInfo, ASN1Set certificates, ASN1Set crls, ASN1Set signedInfos) throws Exception {
        this.version = new ASN1Integer(1L);
        this.digestAlgorithms = digests;
        this.gmt0010ContentInfo = gmt0010ContentInfo;
        this.certificates = certificates;
        this.crls = crls;
        this.signedInfos = signedInfos;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)this.version);
        vector.add((ASN1Encodable)this.digestAlgorithms);
        vector.add((ASN1Encodable)this.gmt0010ContentInfo);
        vector.add((ASN1Encodable)this.certificates);
        vector.add((ASN1Encodable)this.crls);
        vector.add((ASN1Encodable)this.signedInfos);
        return new DERSequence(vector);
    }

    public static GMT0010_SignedData getInstance(Object var0) {
        if (var0 instanceof SignedData) {
            return (GMT0010_SignedData)((Object)var0);
        }
        return var0 != null ? new GMT0010_SignedData(ASN1Sequence.getInstance((Object)var0)) : null;
    }

    private GMT0010_SignedData(ASN1Sequence sequence) {
        Enumeration var2 = sequence.getObjects();
        this.version = ASN1Integer.getInstance(var2.nextElement());
        this.digestAlgorithms = (ASN1Set)var2.nextElement();
        this.gmt0010ContentInfo = GMT0010_ContentInfo.getInstance(var2.nextElement());
        while (var2.hasMoreElements()) {
            ASN1Primitive var3 = (ASN1Primitive)var2.nextElement();
            if (var3 instanceof ASN1TaggedObject) {
                ASN1TaggedObject var4 = (ASN1TaggedObject)var3;
                switch (var4.getTagNo()) {
                    case 0: {
                        this.certificates = ASN1Set.getInstance((ASN1TaggedObject)var4, (boolean)false);
                        break;
                    }
                    case 1: {
                        this.crls = ASN1Set.getInstance((ASN1TaggedObject)var4, (boolean)false);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown tag value " + var4.getTagNo());
                    }
                }
                continue;
            }
            this.signedInfos = (ASN1Set)var3;
        }
    }

    private ASN1Primitive toASN1Object(X509Certificate cert) throws CertificateEncodingException {
        try {
            return new ASN1InputStream(cert.getEncoded()).readObject();
        }
        catch (Exception e) {
            throw new CertificateEncodingException("Exception while encoding certificate: " + e.toString());
        }
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public void setVersion(ASN1Integer version) {
        this.version = version;
    }

    public ASN1Set getDigestAlgorithms() {
        return this.digestAlgorithms;
    }

    public void setDigestAlgorithms(ASN1Set digestAlgorithms) {
        this.digestAlgorithms = digestAlgorithms;
    }

    public GMT0010_ContentInfo getGmt0010ContentInfo() {
        return this.gmt0010ContentInfo;
    }

    public void setGmt0010ContentInfo(GMT0010_ContentInfo gmt0010ContentInfo) {
        this.gmt0010ContentInfo = gmt0010ContentInfo;
    }

    public ASN1Set getCertificates() {
        return this.certificates;
    }

    public void setCertificates(ASN1Set certificates) {
        this.certificates = certificates;
    }

    public ASN1Set getCrls() {
        return this.crls;
    }

    public void setCrls(ASN1Set crls) {
        this.crls = crls;
    }

    public ASN1Set getSignedInfos() {
        return this.signedInfos;
    }

    public void setSignedInfos(ASN1Set signedInfos) {
        this.signedInfos = signedInfos;
    }
}

