/*
 * Decompiled with CFR 0.152.
 */
package encapsulation;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cms.Attributes;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class GMT0010_SignerInfo {
    private ASN1Integer version;
    private SignerIdentifier sid;
    private AlgorithmIdentifier digAlgorithm;
    private ASN1Set authenticatedAttributes;
    private AlgorithmIdentifier digEncryptionAlgorithm;
    private ASN1OctetString encryptedDigest;
    private ASN1Set unauthenticatedAttributes;

    public static GMT0010_SignerInfo getInstance(Object var0) throws IllegalArgumentException {
        if (var0 instanceof GMT0010_SignerInfo) {
            return (GMT0010_SignerInfo)var0;
        }
        return var0 != null ? new GMT0010_SignerInfo(ASN1Sequence.getInstance((Object)var0)) : null;
    }

    public GMT0010_SignerInfo(SignerIdentifier var1, AlgorithmIdentifier var2, ASN1Set var3, AlgorithmIdentifier var4, ASN1OctetString var5, ASN1Set var6) {
        this.version = var1.isTagged() ? new ASN1Integer(3L) : new ASN1Integer(1L);
        this.sid = var1;
        this.digAlgorithm = var2;
        this.authenticatedAttributes = var3;
        this.digEncryptionAlgorithm = var4;
        this.encryptedDigest = var5;
        this.unauthenticatedAttributes = var6;
    }

    public GMT0010_SignerInfo(SignerIdentifier var1, AlgorithmIdentifier var2, Attributes var3, AlgorithmIdentifier var4, ASN1OctetString var5, Attributes var6) {
        this.version = var1.isTagged() ? new ASN1Integer(3L) : new ASN1Integer(1L);
        this.sid = var1;
        this.digAlgorithm = var2;
        this.authenticatedAttributes = ASN1Set.getInstance((Object)var3);
        this.digEncryptionAlgorithm = var4;
        this.encryptedDigest = var5;
        this.unauthenticatedAttributes = ASN1Set.getInstance((Object)var6);
    }

    public GMT0010_SignerInfo(ASN1Sequence var1) {
        Enumeration var2 = var1.getObjects();
        this.version = (ASN1Integer)var2.nextElement();
        this.sid = SignerIdentifier.getInstance(var2.nextElement());
        this.digAlgorithm = AlgorithmIdentifier.getInstance(var2.nextElement());
        Object var3 = var2.nextElement();
        if (var3 instanceof ASN1TaggedObject) {
            this.authenticatedAttributes = ASN1Set.getInstance((ASN1TaggedObject)((ASN1TaggedObject)var3), (boolean)false);
            this.digEncryptionAlgorithm = AlgorithmIdentifier.getInstance(var2.nextElement());
        } else {
            this.authenticatedAttributes = null;
            this.digEncryptionAlgorithm = AlgorithmIdentifier.getInstance(var3);
        }
        this.encryptedDigest = DEROctetString.getInstance(var2.nextElement());
        this.unauthenticatedAttributes = var2.hasMoreElements() ? ASN1Set.getInstance((ASN1TaggedObject)((ASN1TaggedObject)var2.nextElement()), (boolean)false) : null;
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public SignerIdentifier getSID() {
        return this.sid;
    }

    public ASN1Set getAuthenticatedAttributes() {
        return this.authenticatedAttributes;
    }

    public AlgorithmIdentifier getDigestAlgorithm() {
        return this.digAlgorithm;
    }

    public ASN1OctetString getEncryptedDigest() {
        return this.encryptedDigest;
    }

    public AlgorithmIdentifier getDigestEncryptionAlgorithm() {
        return this.digEncryptionAlgorithm;
    }

    public ASN1Set getUnauthenticatedAttributes() {
        return this.unauthenticatedAttributes;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector var1 = new ASN1EncodableVector();
        var1.add((ASN1Encodable)this.version);
        var1.add((ASN1Encodable)this.sid);
        var1.add((ASN1Encodable)this.digAlgorithm);
        if (this.authenticatedAttributes != null) {
            var1.add((ASN1Encodable)new DERTaggedObject(false, 0, (ASN1Encodable)this.authenticatedAttributes));
        }
        var1.add((ASN1Encodable)this.digEncryptionAlgorithm);
        var1.add((ASN1Encodable)this.encryptedDigest);
        if (this.unauthenticatedAttributes != null) {
            var1.add((ASN1Encodable)new DERTaggedObject(false, 1, (ASN1Encodable)this.unauthenticatedAttributes));
        }
        return new DERSequence(var1);
    }
}

