/*
 * Decompiled with CFR 0.152.
 */
package encapsulation;

import java.util.Arrays;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;

public class SM2Signature
extends ASN1Object {
    int ECC_MAX_LEN = 256;
    private static final long serialVersionUID = 1L;
    private byte[] r = new byte[this.ECC_MAX_LEN];
    private byte[] s = new byte[this.ECC_MAX_LEN];

    public SM2Signature() {
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)new DEROctetString(this.r));
        vector.add((ASN1Encodable)new DEROctetString(this.s));
        return new DERSequence(vector);
    }

    public SM2Signature(byte[] r, byte[] s) {
        this.r = r;
        this.s = s;
    }

    public static long getSerialVersionUID() {
        return 1L;
    }

    public byte[] getR() {
        return this.r;
    }

    public void setR(byte[] r) {
        this.r = r;
    }

    public byte[] getS() {
        return this.s;
    }

    public void setS(byte[] s) {
        this.s = s;
    }

    public String toString() {
        return "EccSignature [r=" + Arrays.toString(this.r) + ", s=" + Arrays.toString(this.s) + "]";
    }
}

