/*
 * Decompiled with CFR 0.152.
 */
package protocol;

import java.util.Date;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;

public class SvsRequest
extends ASN1Object {
    private ASN1Integer version = new ASN1Integer(0L);
    private ASN1Integer reqType;
    private ASN1Object request;
    private ASN1GeneralizedTime generalizedTime;

    public SvsRequest(int reqType, ASN1Object request) {
        this.reqType = new ASN1Integer((long)reqType);
        this.request = request;
        this.generalizedTime = new ASN1GeneralizedTime(new Date());
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)this.version);
        vector.add((ASN1Encodable)this.reqType);
        vector.add((ASN1Encodable)new DERTaggedObject(false, this.reqType.getValue().intValue(), (ASN1Encodable)this.request.toASN1Primitive()));
        vector.add((ASN1Encodable)this.generalizedTime);
        DERSequence derSequence = new DERSequence(vector);
        return derSequence;
    }

    public ASN1Object getRequest() {
        return this.request;
    }

    public void setRequest(ASN1Object request) {
        this.request = request;
    }
}

