/*
 * Decompiled with CFR 0.152.
 */
package protocol.encryption.request;

import java.nio.charset.StandardCharsets;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;

public class MultiDecryptDataInitReq
extends ASN1Object {
    private ASN1Integer keyIndex;
    private ASN1OctetString keyValue;
    private ASN1OctetString encKey;
    private ASN1Integer symAlg;
    private ASN1OctetString iv;
    boolean wrapperIV = false;

    public MultiDecryptDataInitReq(int keyIndex, String keyValue, byte[] encKey, long symAlg, byte[] iv) {
        this.keyIndex = new ASN1Integer((long)keyIndex);
        this.keyValue = new DEROctetString(keyValue.getBytes(StandardCharsets.UTF_8));
        this.encKey = new DEROctetString(encKey);
        this.symAlg = new ASN1Integer(symAlg);
        this.iv = new DEROctetString(iv);
        this.wrapperIV = true;
    }

    public MultiDecryptDataInitReq(int keyIndex, String keyValue, byte[] encKey, long symAlg) {
        this.keyIndex = new ASN1Integer((long)keyIndex);
        this.keyValue = new DEROctetString(keyValue.getBytes(StandardCharsets.UTF_8));
        this.encKey = new DEROctetString(encKey);
        this.symAlg = new ASN1Integer(symAlg);
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)this.keyIndex);
        vector.add((ASN1Encodable)this.keyValue);
        vector.add((ASN1Encodable)this.encKey);
        vector.add((ASN1Encodable)this.symAlg);
        if (this.wrapperIV) {
            vector.add((ASN1Encodable)this.iv);
        }
        return new DERSequence(vector);
    }
}

