/*
 * Decompiled with CFR 0.152.
 */
package protocol.encryption.request;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;

public class MultiDecryptDataUpdateReq
extends ASN1Object {
    private ASN1Integer keyID;
    private ASN1OctetString cipherText;
    private ASN1OctetString iv;

    public MultiDecryptDataUpdateReq(long keyID, byte[] cipherText, byte[] iv) {
        this.keyID = new ASN1Integer(keyID);
        this.cipherText = new DEROctetString(cipherText);
        this.iv = new DEROctetString(iv);
    }

    public MultiDecryptDataUpdateReq(long keyID, byte[] cipherText) {
        this.keyID = new ASN1Integer(keyID);
        this.cipherText = new DEROctetString(cipherText);
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)this.keyID);
        vector.add((ASN1Encodable)this.cipherText);
        if (this.iv != null && this.iv.getOctets().length > 0) {
            vector.add((ASN1Encodable)new DERTaggedObject(false, 0, (ASN1Encodable)this.iv));
        }
        return new DERSequence(vector);
    }
}

