/*
 * Decompiled with CFR 0.152.
 */
package protocol.encryption.request;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import protocol.encryption.response.MultiEncryptDataInitResp;

public class MultiEncryptDataFinalReq
extends ASN1Object {
    private ASN1Integer symKeyID;
    private ASN1OctetString plaintext;
    private ASN1OctetString iv;

    public MultiEncryptDataFinalReq(MultiEncryptDataInitResp dataInitResp, byte[] plaintext) {
        this.symKeyID = dataInitResp.getSymKeyID();
        this.iv = dataInitResp.getIv();
        this.plaintext = new DEROctetString(plaintext);
    }

    public MultiEncryptDataFinalReq(long symKeyID, byte[] plaintext, ASN1OctetString iv) {
        this.symKeyID = new ASN1Integer(symKeyID);
        this.plaintext = new DEROctetString(plaintext);
        this.iv = iv;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)this.symKeyID);
        vector.add((ASN1Encodable)new DERTaggedObject(false, 0, (ASN1Encodable)this.plaintext));
        if (this.iv != null && this.iv.getOctets().length > 0) {
            vector.add((ASN1Encodable)new DERTaggedObject(false, 1, (ASN1Encodable)this.iv));
        } else {
            System.out.println("-------------------construct data final req ,iv is :" + this.iv);
        }
        return new DERSequence(vector);
    }
}

