/*
 * Decompiled with CFR 0.152.
 */
package protocol.encryption.request;

import common.SvsOidEnum;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;

public class MultiEncryptDataInitReq
extends ASN1Object {
    private SubjectPublicKeyInfo encPubkey;
    private ASN1Integer pubkeyType;
    private ASN1Integer symAlgo;

    public MultiEncryptDataInitReq(SubjectPublicKeyInfo encPubkey, long symAlgo) {
        this.encPubkey = encPubkey;
        this.pubkeyType = encPubkey.getAlgorithm().getAlgorithm().equals((Object)"RSA") ? new ASN1Integer(SvsOidEnum.SGD_RSA) : new ASN1Integer(SvsOidEnum.SGD_SM2);
        this.symAlgo = new ASN1Integer(symAlgo);
    }

    public MultiEncryptDataInitReq(SubjectPublicKeyInfo encPubkey, long pubkeyType, long symAlgo) {
        this.encPubkey = encPubkey;
        this.pubkeyType = new ASN1Integer(pubkeyType);
        this.symAlgo = new ASN1Integer(symAlgo);
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)this.encPubkey);
        vector.add((ASN1Encodable)this.pubkeyType);
        vector.add((ASN1Encodable)this.symAlgo);
        return new DERSequence(vector);
    }
}

