/*
 * Decompiled with CFR 0.152.
 */
package protocol.encryption.request;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import protocol.encryption.response.MultiEncryptDataInitResp;

public class MultiEncryptDataUpdateReq
extends ASN1Object {
    private ASN1Integer symKeyID;
    private ASN1OctetString plaintext;
    private ASN1OctetString iv;

    public MultiEncryptDataUpdateReq(MultiEncryptDataInitResp dataInitResp, byte[] plaintext) {
        this.symKeyID = dataInitResp.getSymKeyID();
        this.iv = dataInitResp.getIv();
        this.plaintext = new DEROctetString(plaintext);
    }

    public MultiEncryptDataUpdateReq(long symKeyID, byte[] plaintext, ASN1OctetString iv) {
        this.symKeyID = new ASN1Integer(symKeyID);
        this.plaintext = new DEROctetString(plaintext);
        this.iv = iv;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)this.symKeyID);
        vector.add((ASN1Encodable)this.plaintext);
        if (this.iv == null || this.iv.getOctets().length <= 0) {
            System.out.println("no wrapper iv field");
        } else {
            vector.add((ASN1Encodable)this.iv);
        }
        return new DERSequence(vector);
    }
}

