/*
 * Decompiled with CFR 0.152.
 */
package protocol.encryption.request;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;

public class SingleDecryptDataReq
extends ASN1Object {
    private ASN1Integer keyIndex;
    private ASN1OctetString passWord;
    private ASN1Integer symAlgo;
    private ASN1OctetString symKey;
    private ASN1OctetString cipherText;
    private ASN1OctetString iv;
    boolean enableIV = false;

    public SingleDecryptDataReq(Integer keyIndex, long symAlgo, byte[] symKey, byte[] cipherText, ASN1OctetString iv) throws Exception {
        this.keyIndex = new ASN1Integer((long)keyIndex.intValue());
        this.symAlgo = new ASN1Integer(symAlgo);
        this.symKey = new DEROctetString(symKey);
        this.cipherText = new DEROctetString(cipherText);
        this.iv = iv;
    }

    public SingleDecryptDataReq(Integer keyIndex, String passWord, long symAlgo, ASN1OctetString symKey, ASN1OctetString cipherText, byte[] iv) throws Exception {
        this.keyIndex = new ASN1Integer((long)keyIndex.intValue());
        this.passWord = new DEROctetString(passWord.getBytes());
        this.symAlgo = new ASN1Integer(symAlgo);
        this.symKey = symKey;
        this.cipherText = cipherText;
        if (null != iv && !"".equals("") && iv.length > 0) {
            this.enableIV = true;
            this.iv = new DEROctetString(iv);
        }
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)this.keyIndex);
        vector.add((ASN1Encodable)this.passWord);
        vector.add((ASN1Encodable)this.symAlgo);
        vector.add((ASN1Encodable)this.symKey);
        vector.add((ASN1Encodable)this.cipherText);
        if (this.enableIV) {
            vector.add((ASN1Encodable)this.iv);
        }
        return new DERSequence(vector);
    }

    public ASN1Integer getKeyIndex() {
        return this.keyIndex;
    }

    public ASN1Integer getSymAlgo() {
        return this.symAlgo;
    }

    public ASN1OctetString getSymKey() {
        return this.symKey;
    }

    public ASN1OctetString getCipherText() {
        return this.cipherText;
    }

    public ASN1OctetString getIv() {
        return this.iv;
    }
}

