/*
 * Decompiled with CFR 0.152.
 */
package protocol.encryption.request;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import utils.Base64Utils;

public class SingleEncryptDataReq
extends ASN1Object {
    private SubjectPublicKeyInfo encPubkey;
    private ASN1Integer pubkeyType;
    private ASN1Integer symAlgo;
    private ASN1OctetString data;
    private ASN1OctetString iv;

    public SingleEncryptDataReq(SubjectPublicKeyInfo encPubkey, long pubkeyType, long symAlgo, byte[] data, byte[] iv) {
        this.encPubkey = encPubkey;
        this.pubkeyType = new ASN1Integer(pubkeyType);
        this.symAlgo = new ASN1Integer(symAlgo);
        this.data = new DEROctetString(data);
        this.iv = new DEROctetString(iv);
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)this.encPubkey);
        vector.add((ASN1Encodable)this.pubkeyType);
        vector.add((ASN1Encodable)this.symAlgo);
        vector.add((ASN1Encodable)this.data);
        vector.add((ASN1Encodable)this.iv);
        DERSequence derSequence = new DERSequence(vector);
        try {
            System.out.println("\u5185\u5c42\u5305\u6570\u636e:" + Base64Utils.encode(derSequence.getEncoded()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return derSequence;
    }

    public ASN1Integer getPubkeyType() {
        return this.pubkeyType;
    }

    public void setPubkeyType(ASN1Integer pubkeyType) {
        this.pubkeyType = pubkeyType;
    }

    public ASN1Integer getSymAlgo() {
        return this.symAlgo;
    }

    public void setSymAlgo(ASN1Integer symAlgo) {
        this.symAlgo = symAlgo;
    }

    public ASN1OctetString getData() {
        return this.data;
    }

    public void setData(ASN1OctetString data) {
        this.data = data;
    }

    public ASN1OctetString getIv() {
        return this.iv;
    }

    public void setIv(ASN1OctetString iv) {
        this.iv = iv;
    }
}

