/*
 * Decompiled with CFR 0.152.
 */
package protocol.encryption.response;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.util.encoders.Hex;

public class MultiDecryptDataInitResp {
    private ASN1Integer respValue;
    private ASN1Integer symKeyID;

    public MultiDecryptDataInitResp(ASN1Encodable instance) throws Exception {
        DERTaggedObject derTaggedObject = (DERTaggedObject)instance.toASN1Primitive();
        if (derTaggedObject.getObject() instanceof ASN1Integer) {
            this.respValue = ASN1Integer.getInstance((Object)derTaggedObject.getObjectParser(0, true));
        } else {
            ASN1Sequence asn1Sequence = (ASN1Sequence)derTaggedObject.getObject();
            ASN1Encodable[] items = asn1Sequence.toArray();
            this.respValue = ASN1Integer.getInstance((Object)items[0]);
            if (items.length == 2) {
                ASN1TaggedObject symKeyIDObject = DERTaggedObject.getInstance((Object)items[1]);
                ASN1Encodable symKeyIDEnc = symKeyIDObject.getObjectParser(symKeyIDObject.getTagNo(), true);
                String hexSymKeyId = Hex.toHexString((byte[])ASN1OctetString.getInstance((Object)symKeyIDEnc).getOctets());
                int symKeyId = Integer.parseInt(hexSymKeyId, 16);
                this.symKeyID = new ASN1Integer((long)symKeyId);
            }
        }
    }

    public ASN1Integer getRespValue() {
        return this.respValue;
    }

    public ASN1Integer getSymKeyID() {
        return this.symKeyID;
    }

    public boolean isSuccess() {
        return this.respValue.getValue().intValue() == 0;
    }
}

