/*
 * Decompiled with CFR 0.152.
 */
package protocol.encryption.response;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERTaggedObject;

public class MultiDecryptDataUpdateResp {
    private ASN1Integer respValue;
    private ASN1OctetString plaintext;
    private ASN1OctetString iv;

    public MultiDecryptDataUpdateResp(ASN1Encodable instance) throws Exception {
        DERTaggedObject derTaggedObject = (DERTaggedObject)instance.toASN1Primitive();
        if (derTaggedObject.getObject() instanceof ASN1Integer) {
            this.respValue = ASN1Integer.getInstance((Object)derTaggedObject.getObjectParser(0, true));
        } else {
            ASN1Sequence asn1Sequence = (ASN1Sequence)derTaggedObject.getObject();
            ASN1Encodable[] items = asn1Sequence.toArray();
            this.respValue = ASN1Integer.getInstance((Object)items[0]);
            if (this.isSuccess()) {
                ASN1TaggedObject plaintextTag = DERTaggedObject.getInstance((Object)items[1]);
                this.plaintext = ASN1OctetString.getInstance((Object)plaintextTag.getObjectParser(plaintextTag.getTagNo(), true));
                System.out.println(this.plaintext.getOctets());
                System.out.println(new String(this.plaintext.getOctets()));
                if (items.length == 3) {
                    this.iv = DEROctetString.getInstance((Object)items[2]);
                }
            }
        }
    }

    public ASN1Integer getRespValue() {
        return this.respValue;
    }

    public ASN1OctetString getPlaintext() {
        return this.plaintext;
    }

    public ASN1OctetString getIv() {
        return this.iv;
    }

    public boolean isSuccess() {
        return this.respValue.getValue().intValue() == 0;
    }
}

