/*
 * Decompiled with CFR 0.152.
 */
package protocol.encryption.response;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.util.encoders.Hex;

public class MultiEncryptDataInitResp
extends ASN1Object {
    private ASN1Integer respValue;
    private ASN1OctetString symKey;
    private ASN1Integer symKeyID;
    private ASN1OctetString iv;

    public MultiEncryptDataInitResp(int encryptMode, ASN1Encodable instance) throws IOException {
        DERTaggedObject derTaggedObject = (DERTaggedObject)instance.toASN1Primitive();
        if (derTaggedObject.getObject() instanceof ASN1Integer) {
            this.respValue = ASN1Integer.getInstance((Object)derTaggedObject.getObjectParser(0, true));
        } else {
            ASN1Sequence asn1Sequence = (ASN1Sequence)derTaggedObject.getObject();
            ASN1Encodable[] items = asn1Sequence.toArray();
            this.respValue = ASN1Integer.getInstance((Object)items[0]);
            if (this.isSuccess()) {
                ASN1TaggedObject symKeyTag = DERTaggedObject.getInstance((Object)items[1]);
                this.symKey = ASN1OctetString.getInstance((Object)symKeyTag.getObjectParser(symKeyTag.getTagNo(), true));
                System.out.println(this.symKey.getOctets());
                System.out.println(new String(this.symKey.getOctets()));
                ASN1TaggedObject symKeyIDObject = DERTaggedObject.getInstance((Object)items[2]);
                ASN1Encodable symKeyIDEnc = symKeyIDObject.getObjectParser(symKeyIDObject.getTagNo(), true);
                String hexSymKeyId = Hex.toHexString((byte[])ASN1OctetString.getInstance((Object)symKeyIDEnc).getOctets());
                int symKeyId = Integer.parseInt(hexSymKeyId, 16);
                this.symKeyID = new ASN1Integer((long)symKeyId);
                if (items.length == 4) {
                    this.iv = DEROctetString.getInstance((Object)items[3]);
                }
            } else {
                System.out.println("----MultiEncryptDataInit---- code is not  zero--------");
            }
        }
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)this.respValue);
        vector.add((ASN1Encodable)this.symKey);
        vector.add((ASN1Encodable)this.symKeyID);
        vector.add((ASN1Encodable)this.iv);
        System.out.println("-------toASN1Primitive--------------");
        return new DERSequence(vector);
    }

    public ASN1Integer getRespValue() {
        return this.respValue;
    }

    public ASN1OctetString getSymKey() {
        return this.symKey;
    }

    public ASN1OctetString getIv() {
        return this.iv;
    }

    public ASN1Integer getSymKeyID() {
        return this.symKeyID;
    }

    public boolean isSuccess() {
        return this.respValue.getValue().intValue() == 0;
    }
}

