/*
 * Decompiled with CFR 0.152.
 */
package protocol.encryption.response;

import common.SvsOidEnum;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;

public class MultiEncryptDataUpdateResp
extends ASN1Object {
    private ASN1Integer respValue;
    private ASN1OctetString ciphertext;
    private ASN1OctetString iv;

    public MultiEncryptDataUpdateResp(int encryptMode, ASN1Encodable instance) throws Exception {
        DERTaggedObject derTaggedObject = (DERTaggedObject)instance.toASN1Primitive();
        if (derTaggedObject.getObject() instanceof ASN1Integer) {
            this.respValue = ASN1Integer.getInstance((Object)derTaggedObject.getObjectParser(0, true));
        } else {
            ASN1Sequence asn1Sequence = (ASN1Sequence)derTaggedObject.getObject();
            this.respValue = ASN1Integer.getInstance((Object)asn1Sequence.getObjectAt(0));
            if (this.isSuccess()) {
                DERTaggedObject cipherObject = (DERTaggedObject)asn1Sequence.getObjectAt(1);
                this.ciphertext = DEROctetString.getInstance((Object)cipherObject.getObject());
                if ((long)encryptMode == SvsOidEnum.SGD_SM1_CBC || (long)encryptMode == SvsOidEnum.SGD_SM1_OFB || (long)encryptMode == SvsOidEnum.SGD_SM4_OFB || (long)encryptMode == SvsOidEnum.SGD_SM4_CBC) {
                    DERTaggedObject ivObject = (DERTaggedObject)asn1Sequence.getObjectAt(2);
                    this.iv = DEROctetString.getInstance((Object)ivObject.getObject());
                }
            }
        }
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)this.respValue);
        vector.add((ASN1Encodable)this.ciphertext);
        vector.add((ASN1Encodable)this.iv);
        return new DERSequence(vector);
    }

    public ASN1Integer getRespValue() {
        return this.respValue;
    }

    public ASN1OctetString getCipherText() {
        return this.ciphertext;
    }

    public ASN1OctetString getIv() {
        return this.iv;
    }

    public boolean isSuccess() {
        return this.respValue.getValue().intValue() == 0;
    }
}

