/*
 * Decompiled with CFR 0.152.
 */
package protocol.encryption.response;

import common.SvsOidEnum;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERTaggedObject;

public class SingleEncryptDataResp {
    private ASN1Integer respValue;
    private ASN1OctetString cipherText;
    private ASN1OctetString symKey;
    private ASN1OctetString iv;
    private int encryptMode = -1;

    public SingleEncryptDataResp(int encryptMode, ASN1Encodable instance) throws Exception {
        DERTaggedObject derTaggedObject = (DERTaggedObject)instance.toASN1Primitive();
        if (derTaggedObject.getObject() instanceof ASN1Integer) {
            this.respValue = ASN1Integer.getInstance((Object)derTaggedObject.getObjectParser(0, true));
        } else {
            ASN1Sequence asn1Sequence = (ASN1Sequence)derTaggedObject.getObject();
            this.respValue = ASN1Integer.getInstance((Object)asn1Sequence.getObjectAt(0));
            if (this.isSuccess()) {
                DERTaggedObject cipherObject = (DERTaggedObject)asn1Sequence.getObjectAt(1);
                this.cipherText = DEROctetString.getInstance((Object)cipherObject.getObject());
                DERTaggedObject symKeyObject = (DERTaggedObject)asn1Sequence.getObjectAt(2);
                this.symKey = DEROctetString.getInstance((Object)symKeyObject.getObject());
                if ((long)encryptMode == SvsOidEnum.SGD_SM1_CBC || (long)encryptMode == SvsOidEnum.SGD_SM1_OFB || (long)encryptMode == SvsOidEnum.SGD_SM4_OFB || (long)encryptMode == SvsOidEnum.SGD_SM4_CBC) {
                    DERTaggedObject ivObject = (DERTaggedObject)asn1Sequence.getObjectAt(3);
                    this.iv = DEROctetString.getInstance((Object)ivObject.getObject());
                }
            } else {
                System.out.println("single encrypt data resp error");
            }
        }
    }

    public ASN1Integer getRespValue() {
        return this.respValue;
    }

    public ASN1OctetString getCipherText() {
        return this.cipherText;
    }

    public ASN1OctetString getSymKey() {
        return this.symKey;
    }

    public ASN1OctetString getIv() {
        return this.iv;
    }

    public boolean isSuccess() {
        return this.respValue.getValue().intValue() == 0;
    }
}

