/*
 * Decompiled with CFR 0.152.
 */
package protocol.hash.request;

import java.nio.charset.StandardCharsets;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;

public class HashInitReq
extends ASN1Object {
    private ASN1Integer signMethod;
    private SubjectPublicKeyInfo signerPublicKey;
    private ASN1OctetString signerID;

    public HashInitReq(long signMethod, SubjectPublicKeyInfo signerPublicKey, String signerID) {
        this.signMethod = new ASN1Integer(signMethod);
        this.signerPublicKey = signerPublicKey;
        this.signerID = new DEROctetString(signerID.getBytes(StandardCharsets.UTF_8));
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)this.signMethod);
        vector.add((ASN1Encodable)new DERTaggedObject(false, 0, (ASN1Encodable)this.signerPublicKey));
        vector.add((ASN1Encodable)new DERTaggedObject(false, 1, (ASN1Encodable)this.signerID));
        return new DERSequence(vector);
    }

    public ASN1Integer getSignMethod() {
        return this.signMethod;
    }

    public void setSignMethod(ASN1Integer signMethod) {
        this.signMethod = signMethod;
    }

    public ASN1OctetString getSignerID() {
        return this.signerID;
    }

    public void setSignerID(ASN1OctetString signerID) {
        this.signerID = signerID;
    }
}

