/*
 * Decompiled with CFR 0.152.
 */
package protocol.hash.response;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;

public class HashFinalResp
extends ASN1Object {
    private ASN1Integer respValue;
    private ASN1OctetString hashValue;

    public HashFinalResp(ASN1Encodable instance) throws Exception {
        DERTaggedObject derTaggedObject = (DERTaggedObject)instance.toASN1Primitive();
        if (derTaggedObject.getObject() instanceof ASN1Integer) {
            this.respValue = ASN1Integer.getInstance((Object)derTaggedObject.getObjectParser(0, true));
        } else {
            ASN1Sequence asn1Sequence = (ASN1Sequence)derTaggedObject.getObject();
            this.respValue = ASN1Integer.getInstance((Object)asn1Sequence.getObjectAt(0));
            this.hashValue = DEROctetString.getInstance((Object)asn1Sequence.getObjectAt(1));
        }
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)this.respValue);
        vector.add((ASN1Encodable)this.hashValue);
        return new DERSequence(vector);
    }

    public ASN1Integer getRespValue() {
        return this.respValue;
    }

    public void setRespValue(ASN1Integer respValue) {
        this.respValue = respValue;
    }

    public ASN1OctetString getHashValue() {
        return this.hashValue;
    }

    public void setHashValue(ASN1OctetString hashValue) {
        this.hashValue = hashValue;
    }

    public boolean isSuccess() {
        return this.respValue.getValue().intValue() == 0;
    }
}

