/*
 * Decompiled with CFR 0.152.
 */
package protocol.hash.response;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;

public class HashInitResp
extends ASN1Object {
    private ASN1Integer respValue;
    private ASN1Integer hashId;

    public HashInitResp(ASN1Encodable instance) throws Exception {
        DERTaggedObject derTaggedObject = (DERTaggedObject)instance.toASN1Primitive();
        if (derTaggedObject.getObject() instanceof ASN1Integer) {
            this.respValue = ASN1Integer.getInstance((Object)derTaggedObject.getObjectParser(0, true));
            this.hashId = ASN1Integer.getInstance((Object)derTaggedObject.getObjectParser(1, true));
        } else {
            ASN1Sequence asn1Sequence = (ASN1Sequence)derTaggedObject.getObject();
            this.respValue = ASN1Integer.getInstance((Object)asn1Sequence.getObjectAt(0));
            this.hashId = ASN1Integer.getInstance((Object)asn1Sequence.getObjectAt(1));
        }
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)this.respValue);
        vector.add((ASN1Encodable)this.hashId);
        return new DERSequence(vector);
    }

    public ASN1Integer getRespValue() {
        return this.respValue;
    }

    public void setRespValue(ASN1Integer respValue) {
        this.respValue = respValue;
    }

    public ASN1Integer getHashId() {
        return this.hashId;
    }

    public void setHashId(ASN1Integer hashId) {
        this.hashId = hashId;
    }

    public boolean isSuccess() {
        return this.respValue.getValue().intValue() == 0;
    }
}

