/*
 * Decompiled with CFR 0.152.
 */
package protocol.request;

import java.nio.charset.StandardCharsets;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;

public class ExportAppCertByUsageReq
extends ASN1Object {
    private ASN1OctetString appName;
    private ASN1Integer certUsage;

    public ExportAppCertByUsageReq() {
    }

    public ExportAppCertByUsageReq(String appName, short certUsage) {
        this.appName = new DEROctetString(appName.getBytes(StandardCharsets.UTF_8));
        this.certUsage = certUsage == 2 ? new ASN1Integer(0L) : new ASN1Integer((long)certUsage);
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)this.appName);
        vector.add((ASN1Encodable)this.certUsage);
        return new DERSequence(vector);
    }

    public ASN1OctetString getAppName() {
        return this.appName;
    }

    public void setAppName(ASN1OctetString appName) {
        this.appName = appName;
    }

    public ASN1Integer getCertUsage() {
        return this.certUsage;
    }

    public void setCertUsage(ASN1Integer certUsage) {
        this.certUsage = certUsage;
    }
}

