/*
 * Decompiled with CFR 0.152.
 */
package protocol.request;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERSequence;

public class ParseCertReq
extends ASN1Object {
    private ASN1Integer infoType;
    private X509Certificate cert;

    public ParseCertReq(Integer infoType, byte[] cert) throws CertificateException, NoSuchProviderException {
        this.infoType = new ASN1Integer((long)infoType.intValue());
        CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
        ByteArrayInputStream inStream = new ByteArrayInputStream(cert);
        this.cert = (X509Certificate)cf.generateCertificate(inStream);
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)this.infoType);
        try {
            vector.add((ASN1Encodable)ASN1Primitive.fromByteArray((byte[])this.cert.getEncoded()));
        }
        catch (IOException iOException) {
        }
        catch (CertificateEncodingException certificateEncodingException) {
            // empty catch block
        }
        return new DERSequence(vector);
    }
}

