/*
 * Decompiled with CFR 0.152.
 */
package protocol.request;

import java.nio.charset.StandardCharsets;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;

public class SignDataFinalReq
extends ASN1Object {
    private ASN1Integer signMethod;
    private ASN1Integer keyIndex;
    private ASN1OctetString keyValue;
    private ASN1Integer hashValueLen;
    private ASN1OctetString hashValue;

    public SignDataFinalReq() {
    }

    public SignDataFinalReq(long signMethod, Integer keyIndex, String keyValue, Integer hashValueLen, byte[] hashValue) {
        this.signMethod = new ASN1Integer(signMethod);
        this.keyIndex = new ASN1Integer((long)keyIndex.intValue());
        this.keyValue = new DEROctetString(keyValue.getBytes(StandardCharsets.UTF_8));
        this.hashValueLen = new ASN1Integer((long)hashValueLen.intValue());
        this.hashValue = new DEROctetString(hashValue);
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)this.signMethod);
        vector.add((ASN1Encodable)this.keyIndex);
        vector.add((ASN1Encodable)this.keyValue);
        vector.add((ASN1Encodable)this.hashValueLen);
        vector.add((ASN1Encodable)this.hashValue);
        return new DERSequence(vector);
    }

    public ASN1Integer getSignMethod() {
        return this.signMethod;
    }

    public void setSignMethod(ASN1Integer signMethod) {
        this.signMethod = signMethod;
    }

    public ASN1Integer getKeyIndex() {
        return this.keyIndex;
    }

    public void setKeyIndex(ASN1Integer keyIndex) {
        this.keyIndex = keyIndex;
    }

    public ASN1OctetString getKeyValue() {
        return this.keyValue;
    }

    public void setKeyValue(ASN1OctetString keyValue) {
        this.keyValue = keyValue;
    }

    public ASN1Integer getHashValueLen() {
        return this.hashValueLen;
    }

    public void setHashValueLen(ASN1Integer hashValueLen) {
        this.hashValueLen = hashValueLen;
    }

    public ASN1OctetString getHashValue() {
        return this.hashValue;
    }

    public void setHashValue(ASN1OctetString hashValue) {
        this.hashValue = hashValue;
    }
}

