/*
 * Decompiled with CFR 0.152.
 */
package protocol.request;

import java.nio.charset.StandardCharsets;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;

public class SignDataReq
extends ASN1Object {
    private ASN1Integer signMethod;
    private ASN1Integer keyIndex;
    private ASN1OctetString keyValue;
    private ASN1Integer inDataLen;
    private ASN1OctetString inData;

    public SignDataReq(long signMethod, int keyIndex, String keyValue, byte[] indata) {
        this.signMethod = new ASN1Integer(signMethod);
        this.keyIndex = new ASN1Integer((long)keyIndex);
        this.keyValue = new DEROctetString(keyValue.getBytes(StandardCharsets.UTF_8));
        this.inDataLen = new ASN1Integer((long)indata.length);
        this.inData = new DEROctetString(indata);
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)this.signMethod);
        vector.add((ASN1Encodable)this.keyIndex);
        vector.add((ASN1Encodable)this.keyValue);
        vector.add((ASN1Encodable)this.inDataLen);
        vector.add((ASN1Encodable)this.inData);
        return new DERSequence(vector);
    }
}

