/*
 * Decompiled with CFR 0.152.
 */
package protocol.request;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;

public class SignDataUpdateReq
extends ASN1Object {
    private ASN1Integer signMethod;
    private ASN1Integer hashValueLen;
    private ASN1OctetString hashValue;
    private ASN1Integer inDataLen;
    private ASN1OctetString inData;

    public SignDataUpdateReq() {
    }

    public SignDataUpdateReq(long signMethod, Integer hashValueLen, byte[] hashValue, Integer inDataLen, byte[] inData) {
        this.signMethod = new ASN1Integer(signMethod);
        this.hashValueLen = new ASN1Integer((long)hashValueLen.intValue());
        this.hashValue = new DEROctetString(hashValue);
        this.inDataLen = new ASN1Integer((long)inDataLen.intValue());
        this.inData = new DEROctetString(inData);
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)this.signMethod);
        vector.add((ASN1Encodable)this.hashValueLen);
        vector.add((ASN1Encodable)this.hashValue);
        vector.add((ASN1Encodable)this.inDataLen);
        vector.add((ASN1Encodable)this.inData);
        return new DERSequence(vector);
    }
}

