/*
 * Decompiled with CFR 0.152.
 */
package protocol.request;

import java.nio.charset.StandardCharsets;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;

public class SignMessageInitReq
extends ASN1Object {
    private ASN1Integer signMethod;
    private ASN1OctetString signerPublicKey;
    private ASN1Integer signerIDLen;
    private ASN1OctetString signerID;
    private ASN1Integer inDataLen;
    private ASN1OctetString inData;

    public SignMessageInitReq(long signMethod, byte[] signerPublicKey, Integer signerIDLen, String signerID, Integer inDataLen, String inData) {
        this.signMethod = new ASN1Integer(signMethod);
        this.signerPublicKey = new DEROctetString(signerPublicKey);
        this.signerIDLen = new ASN1Integer((long)signerIDLen.intValue());
        this.signerID = new DEROctetString(signerID.getBytes(StandardCharsets.UTF_8));
        this.inDataLen = new ASN1Integer((long)inDataLen.intValue());
        this.inData = new DEROctetString(inData.getBytes(StandardCharsets.UTF_8));
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)this.signMethod);
        vector.add((ASN1Encodable)new DERTaggedObject(false, 0, (ASN1Encodable)this.signerPublicKey));
        vector.add((ASN1Encodable)new DERTaggedObject(false, 1, (ASN1Encodable)this.signerIDLen));
        vector.add((ASN1Encodable)new DERTaggedObject(false, 2, (ASN1Encodable)this.signerID));
        vector.add((ASN1Encodable)this.inDataLen);
        vector.add((ASN1Encodable)this.inData);
        return new DERSequence(vector);
    }

    public ASN1Integer getSignMethod() {
        return this.signMethod;
    }

    public void setSignMethod(ASN1Integer signMethod) {
        this.signMethod = signMethod;
    }

    public ASN1OctetString getSignerPublicKey() {
        return this.signerPublicKey;
    }

    public void setSignerPublicKey(ASN1OctetString signerPublicKey) {
        this.signerPublicKey = signerPublicKey;
    }

    public ASN1Integer getSignerIDLen() {
        return this.signerIDLen;
    }

    public void setSignerIDLen(ASN1Integer signerIDLen) {
        this.signerIDLen = signerIDLen;
    }

    public ASN1OctetString getSignerID() {
        return this.signerID;
    }

    public void setSignerID(ASN1OctetString signerID) {
        this.signerID = signerID;
    }

    public ASN1Integer getInDataLen() {
        return this.inDataLen;
    }

    public void setInDataLen(ASN1Integer inDataLen) {
        this.inDataLen = inDataLen;
    }

    public ASN1OctetString getInData() {
        return this.inData;
    }

    public void setInData(ASN1OctetString inData) {
        this.inData = inData;
    }
}

