/*
 * Decompiled with CFR 0.152.
 */
package protocol.request;

import java.nio.charset.StandardCharsets;
import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;

public class SignMessageReq
extends ASN1Object {
    private ASN1Integer signMethod;
    private ASN1Integer keyIndex;
    private ASN1OctetString keyValue;
    private ASN1Integer inDataLen;
    private ASN1OctetString inData;
    private ASN1Boolean hashFlag;
    private ASN1Boolean originalText;
    private ASN1Boolean certificateChain;
    private ASN1Boolean crl;
    private ASN1Boolean authenticationAttributes;

    public SignMessageReq(long signMethod, int keyIndex, String keyValue, int inDataLen, byte[] inData, Boolean hashFlag, Boolean originalText, Boolean certificateChain, Boolean crl, Boolean authenticationAttributes) {
        this.signMethod = new ASN1Integer(signMethod);
        this.keyIndex = new ASN1Integer((long)keyIndex);
        this.keyValue = new DEROctetString(keyValue.getBytes(StandardCharsets.UTF_8));
        this.inDataLen = new ASN1Integer((long)inDataLen);
        this.inData = new DEROctetString(inData);
        this.hashFlag = ASN1Boolean.getInstance((boolean)hashFlag);
        this.originalText = ASN1Boolean.getInstance((boolean)originalText);
        this.certificateChain = ASN1Boolean.getInstance((boolean)certificateChain);
        this.crl = ASN1Boolean.getInstance((boolean)crl);
        this.authenticationAttributes = ASN1Boolean.getInstance((boolean)authenticationAttributes);
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)this.signMethod);
        vector.add((ASN1Encodable)this.keyIndex);
        vector.add((ASN1Encodable)this.keyValue);
        vector.add((ASN1Encodable)this.inDataLen);
        vector.add((ASN1Encodable)this.inData);
        vector.add((ASN1Encodable)this.hashFlag);
        vector.add((ASN1Encodable)new DERTaggedObject(false, 0, (ASN1Encodable)this.originalText));
        vector.add((ASN1Encodable)new DERTaggedObject(false, 1, (ASN1Encodable)this.certificateChain));
        vector.add((ASN1Encodable)new DERTaggedObject(false, 2, (ASN1Encodable)this.crl));
        vector.add((ASN1Encodable)new DERTaggedObject(false, 3, (ASN1Encodable)this.authenticationAttributes));
        return new DERSequence(vector);
    }

    public ASN1Integer getSignMethod() {
        return this.signMethod;
    }

    public void setSignMethod(ASN1Integer signMethod) {
        this.signMethod = signMethod;
    }

    public ASN1Integer getKeyIndex() {
        return this.keyIndex;
    }

    public void setKeyIndex(ASN1Integer keyIndex) {
        this.keyIndex = keyIndex;
    }

    public ASN1OctetString getKeyValue() {
        return this.keyValue;
    }

    public void setKeyValue(ASN1OctetString keyValue) {
        this.keyValue = keyValue;
    }

    public ASN1Integer getInDataLen() {
        return this.inDataLen;
    }

    public void setInDataLen(ASN1Integer inDataLen) {
        this.inDataLen = inDataLen;
    }

    public ASN1OctetString getInData() {
        return this.inData;
    }

    public void setInData(ASN1OctetString inData) {
        this.inData = inData;
    }

    public ASN1Boolean getHashFlag() {
        return this.hashFlag;
    }

    public void setHashFlag(ASN1Boolean hashFlag) {
        this.hashFlag = hashFlag;
    }

    public ASN1Boolean getOriginalText() {
        return this.originalText;
    }

    public void setOriginalText(ASN1Boolean originalText) {
        this.originalText = originalText;
    }

    public ASN1Boolean getCertificateChain() {
        return this.certificateChain;
    }

    public void setCertificateChain(ASN1Boolean certificateChain) {
        this.certificateChain = certificateChain;
    }

    public ASN1Boolean getCrl() {
        return this.crl;
    }

    public void setCrl(ASN1Boolean crl) {
        this.crl = crl;
    }

    public ASN1Boolean getAuthenticationAttributes() {
        return this.authenticationAttributes;
    }

    public void setAuthenticationAttributes(ASN1Boolean authenticationAttributes) {
        this.authenticationAttributes = authenticationAttributes;
    }
}

