/*
 * Decompiled with CFR 0.152.
 */
package protocol.request;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;

public class SignMessageUpdateReq
extends ASN1Object {
    private ASN1Integer signMethod;
    private ASN1Integer hashValueLen;
    private ASN1OctetString hashValue;
    private ASN1Integer inDataLen;
    private ASN1OctetString inData;

    public SignMessageUpdateReq(long signMethod, Integer hashValueLen, byte[] hashValue, Integer inDataLen, byte[] inData) {
        this.signMethod = new ASN1Integer(signMethod);
        this.hashValueLen = new ASN1Integer((long)hashValueLen.intValue());
        this.hashValue = new DEROctetString(hashValue);
        this.inDataLen = new ASN1Integer((long)inDataLen.intValue());
        this.inData = new DEROctetString(inData);
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)this.signMethod);
        vector.add((ASN1Encodable)this.hashValueLen);
        vector.add((ASN1Encodable)this.hashValue);
        vector.add((ASN1Encodable)this.inDataLen);
        vector.add((ASN1Encodable)this.inData);
        return new DERSequence(vector);
    }

    public ASN1Integer getSignMethod() {
        return this.signMethod;
    }

    public void setSignMethod(ASN1Integer signMethod) {
        this.signMethod = signMethod;
    }

    public ASN1Integer getHashValueLen() {
        return this.hashValueLen;
    }

    public void setHashValueLen(ASN1Integer hashValueLen) {
        this.hashValueLen = hashValueLen;
    }

    public ASN1OctetString getHashValue() {
        return this.hashValue;
    }

    public void setHashValue(ASN1OctetString hashValue) {
        this.hashValue = hashValue;
    }

    public ASN1Integer getInDataLen() {
        return this.inDataLen;
    }

    public void setInDataLen(ASN1Integer inDataLen) {
        this.inDataLen = inDataLen;
    }

    public ASN1OctetString getInData() {
        return this.inData;
    }

    public void setInData(ASN1OctetString inData) {
        this.inData = inData;
    }
}

