/*
 * Decompiled with CFR 0.152.
 */
package protocol.request;

import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERSequence;

public class ValidateCertReq
extends ASN1Object {
    private X509Certificate cert;
    private ASN1Boolean ocsp;

    public ValidateCertReq(X509Certificate cert, Boolean ocsp) {
        this.cert = cert;
        this.ocsp = ASN1Boolean.getInstance((Object)ocsp);
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        try {
            vector.add((ASN1Encodable)ASN1Primitive.fromByteArray((byte[])this.cert.getEncoded()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CertificateEncodingException e) {
            e.printStackTrace();
        }
        vector.add((ASN1Encodable)this.ocsp);
        return new DERSequence(vector);
    }

    public X509Certificate getCert() {
        return this.cert;
    }

    public void setCert(X509Certificate cert) {
        this.cert = cert;
    }

    public ASN1Boolean getOcsp() {
        return this.ocsp;
    }

    public void setOcsp(ASN1Boolean ocsp) {
        this.ocsp = ocsp;
    }
}

