/*
 * Decompiled with CFR 0.152.
 */
package protocol.request;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;

public class VerifySignDataFinalReq
extends ASN1Object {
    private ASN1Integer signMethod;
    private ASN1Integer type;
    private X509Certificate cert;
    private ASN1OctetString certSN;
    private ASN1Integer inDataLen;
    private ASN1OctetString inData;
    private ASN1OctetString signature;
    private ASN1Integer verifyLevel;

    public VerifySignDataFinalReq() {
    }

    public VerifySignDataFinalReq(long signMethod, Integer type, X509Certificate cert, String certSN, Integer inDataLen, String inData, byte[] signature, Integer verifyLevel) {
        this.signMethod = new ASN1Integer(signMethod);
        this.type = new ASN1Integer((long)type.intValue());
        this.cert = cert;
        this.certSN = new DEROctetString(certSN.getBytes(StandardCharsets.UTF_8));
        this.inDataLen = new ASN1Integer((long)inDataLen.intValue());
        this.inData = new DEROctetString(inData.getBytes(StandardCharsets.UTF_8));
        this.signature = new DEROctetString(signature);
        this.verifyLevel = new ASN1Integer((long)verifyLevel.intValue());
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)this.signMethod);
        vector.add((ASN1Encodable)new DERTaggedObject(false, 0, (ASN1Encodable)this.type));
        try {
            vector.add((ASN1Encodable)new DERTaggedObject(false, 1, (ASN1Encodable)ASN1Primitive.fromByteArray((byte[])this.cert.getEncoded())));
        }
        catch (IOException iOException) {
        }
        catch (CertificateEncodingException certificateEncodingException) {
            // empty catch block
        }
        vector.add((ASN1Encodable)this.certSN);
        vector.add((ASN1Encodable)this.inDataLen);
        vector.add((ASN1Encodable)this.inData);
        vector.add((ASN1Encodable)this.signature);
        vector.add((ASN1Encodable)this.verifyLevel);
        return new DERSequence(vector);
    }

    public ASN1Integer getSignMethod() {
        return this.signMethod;
    }

    public void setSignMethod(ASN1Integer signMethod) {
        this.signMethod = signMethod;
    }

    public ASN1Integer getType() {
        return this.type;
    }

    public void setType(ASN1Integer type) {
        this.type = type;
    }

    public X509Certificate getCert() {
        return this.cert;
    }

    public void setCert(X509Certificate cert) {
        this.cert = cert;
    }

    public ASN1OctetString getCertSN() {
        return this.certSN;
    }

    public void setCertSN(ASN1OctetString certSN) {
        this.certSN = certSN;
    }

    public ASN1Integer getInDataLen() {
        return this.inDataLen;
    }

    public void setInDataLen(ASN1Integer inDataLen) {
        this.inDataLen = inDataLen;
    }

    public ASN1OctetString getInData() {
        return this.inData;
    }

    public void setInData(ASN1OctetString inData) {
        this.inData = inData;
    }

    public ASN1OctetString getSignature() {
        return this.signature;
    }

    public void setSignature(ASN1OctetString signature) {
        this.signature = signature;
    }

    public ASN1Integer getVerifyLevel() {
        return this.verifyLevel;
    }

    public void setVerifyLevel(ASN1Integer verifyLevel) {
        this.verifyLevel = verifyLevel;
    }
}

